<?php

use WpBookingHotel\Factory as FactoryAlias;
use WpBookingHotel\Html\ToolBar;
use WpBookingHotel\Html\WpBookingHotelHtmlBackend as WpBookingHotelHtmlBackendAlias;
use WpBookingHotel\Utilities\Utility as UtilityAlias;
use WpBookingHotel\Language\Text;
use WpBookingHotelAdmin\app\Html\HtmlBackend;

$doc = FactoryAlias::getDocument();
WpBookingHotelHtmlBackendAlias::load_jquery_library('icheck');
ToolBar::setTitle("List sms");
WpBookingHotelHtmlBackendAlias::load_jquery_library('datatables');
?>
<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendGoToLink("sms.form")) ?>" name="admin-form" method="post">
        <div class="view-list-sms">
            <table id="example" class="display table">
                <thead>
                    <tr>
                        <th class="nowrap"></th>
                        <th class="view-list-sms-th nowrap"><?php esc_attr_e('Account ID','wpbookinghotel')?></th>
                        <th class="view-list-sms-th nowrap"><?php esc_attr_e('Auth Token','wpbookinghotel')?></th>
                        <th class="view-list-sms-th nowrap"><?php esc_attr_e('Phone register','wpbookinghotel')?></th>
                        <th class="view-list-sms-th nowrap"><?php esc_attr_e('Published','wpbookinghotel')?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item){?>
                    <tr>
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                        <td class="account-id nowrap"><?php esc_html_e($item->account_id); ?></td>
                        <td class="auth-token nowrap"><?php esc_html_e($item->auth_token); ?></td>
                        <td class="phone-register nowrap">
                            <?php
                                $phone_register = isset($item->phone_register)?$item->phone_register:'';
                                if($phone_register['0'] == 0) {
                                    $phone_register = substr($phone_register,1);
                                }
                                $phonecode = isset($item->phonecode)?$item->phonecode:'';
                                echo (esc_html('+'.$phonecode . $phone_register));
                            ?>
                        </td>
                        <td class="nowrap">
                            <?php if ($item->published == 1) { ?>
                                <div class="published">
                                    <i class="fas fa-check-square" title="<?php esc_attr_e('Public','wpbookinghotel'); ?>"></i>
                                </div>
                            <?php } else { ?>
                                <div class="unpublished">
                                    <i class="far fa-times-circle" title="<?php esc_attr_e('Not Public','wpbookinghotel'); ?>"></i>
                                </div>
                            <?php } ?>
                        </td>
                        <td class="sms-action">
                            <a href="<?php echo(UtilityAlias::getBackendGoToLink("sms.form",array('id'=>$item->id))) ?>" class="btn-edit" title="<?php esc_attr_e('Edit','wpbookinghotel')?>"><i class="fas fa-edit"></i></a>
                            <a href="<?php echo(UtilityAlias::goToTaskByView("sms","sms.delete",array('id'=>$item->id))) ?>" class="btn-delete" title="<?php esc_attr_e('Delete','wpbookinghotel')?>"><i class="fas fa-trash-alt"></i></a>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="">
    </form>
<?php
$doc->addLessStyleSheet('admin/app/assets/less/view_list_sms.less');
$doc->addStyleSheet('admin_woopanel/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.view-list-sms', 'view_list_sms', array(

), "admin/app/assets/js/view_list_sms.js");
?>