<?php

use WpBookingHotel\Factory as FactoryAlias;
use WpBookingHotel\Html\ToolBar;
use WpBookingHotel\Html\WpBookingHotelHtmlBackend as WpBookingHotelHtmlBackendAlias;
use WpBookingHotel\Utilities\Utility as UtilityAlias;
use WpBookingHotel\Language\Text;
use WpBookingHotelAdmin\app\Html\HtmlBackend;

$doc = FactoryAlias::getDocument();
WpBookingHotelHtmlBackendAlias::load_jquery_library('icheck');
ToolBar::setTitle("List room type");
WpBookingHotelHtmlBackendAlias::load_jquery_library('datatables');
?>
<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendGoToLink("roomtype.form")) ?>" name="admin-form" method="post">
        <div class="view-list-roomtype">
            <table id="example" class="display table">
                <thead>
                    <tr>
                        <th class="nowrap"></th>
                        <th class="nowrap"><?php esc_html_e('Name','wpbookinghotel')?></th>
                        <th class="nowrap"><?php esc_html_e('Image','wpbookinghotel')?></th>
                        <th class="nowrap"><?php esc_html_e('Published','wpbookinghotel')?></th>
                        <th class="nowrap"><?php esc_html_e('Amenity','wpbookinghotel')?></th>
                        <th class="nowrap"><?php esc_html_e('Id','wpbookinghotel')?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item){?>
                    <tr>
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                        <td class="name nowrap"><?php echo (esc_html($item->name)); ?></td>
                        <td class="image nowrap">
                            <div class="img-box">
                                <img class="roomtype-image" src="<?php echo (esc_attr(FactoryAlias::getRootUrlPlugin()))  ?>/<?php echo (esc_attr($item->image)); ?>" alt="roomtype-image"/>
                            </div>
                        </td>
                        <td class="nowrap">
                            <?php if ($item->published == 1) { ?>
                                <div class="published">
                                    <i class="fas fa-check-square" title="<?php esc_attr_e('Public','wpbookinghotel');?>"></i>
                                </div>
                            <?php } else { ?>
                                <div class="unpublished">
                                    <i class="far fa-times-circle" title="<?php esc_attr_e('Not Public','wpbookinghotel');?>"></i>
                                </div>
                            <?php } ?>
                        </td>
                        <td class="nowrap amenity">
                            <?php foreach ($item->list_amenity as $amenity){ ?>
                                <?php echo "- $amenity <br/>" ?>
                            <?php } ?>
                        </td>
                        <td class="id nowrap"><?php echo (esc_html($item->id)); ?></td>
                        <td class="state-action">
                            <a href="<?php echo(UtilityAlias::getBackendGoToLink("roomtype.form",array('id'=>$item->id))) ?>" class="btn-edit" title="<?php esc_attr_e('Edit','wpbookinghotel')?>"><i class="fas fa-edit"></i></a>
                            <a href="<?php echo(UtilityAlias::goToTaskByView("roomtype","roomtype.delete",array('id'=>$item->id))) ?>" class="btn-delete" title="<?php esc_attr_e('Delete','wpbookinghotel')?>"><i class="fas fa-trash-alt"></i></a>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="">
    </form>
<?php
$doc->addLessStyleSheet('admin/app/assets/less/view_list_roomtype.less');
$doc->addStyleSheet('admin/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.view-list-roomtype', 'view_list_roomtype', array(

), "admin/app/assets/js/view_list_roomtype.js");
?>