<?php

namespace WpBookingHotelAdmin\app\views\roomtype;

use WpBookingHotel\Html\ToolBar;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Mvc\View\View;
use WpBookingHotel\Factory as FactoryAlias;
use WpBookingHotelAdmin\app\helpers\CustomizeHelper;

class RoomtypeView extends View
{
    public function display($tpl)
    {
        $modelroomtype = Model::getInstance("roomtype");
        $input = FactoryAlias::getInput();
        switch ($tpl) {
            case "list":
                ToolBar::add("roomtype.add");
                ToolBar::delete("roomtype.delete_list");
                ToolBar::_clone("roomtype.clone_list");
                $model = Model::getInstance("roomtypes");
                $this->list = $model->getList();
                break;
            case "form":
                ToolBar::setTitle('Edit roomtype');
                ToolBar::apply("roomtype.apply");
                ToolBar::save("roomtype.save");
                ToolBar::cancel("roomtype.cancel");
                ToolBar::back_to_list("roomtype.back_to_list");
                $id = $input->getInt('id', 0);
                $this->item = $modelroomtype->getItem($id);
                $this->form = $modelroomtype->getForm();
                $this->list_customize=CustomizeHelper::get_list_customize("roomtype");
                $this->list_customize=CustomizeHelper::assignValue( $this->list_customize,$this->item);
                break;
        }
        return parent::display($tpl);
    }
}