<?php

use WpBookingHotel\Factory as FactoryAlias;
use WpBookingHotel\Html\ToolBar;
use WpBookingHotel\Html\WpBookingHotelHtmlBackend as WpBookingHotelHtmlBackendAlias;
use WpBookingHotel\Utilities\Utility as UtilityAlias;
use WpBookingHotel\Language\Text;
use WpBookingHotelAdmin\app\Html\HtmlBackend;

$doc = FactoryAlias::getDocument();
WpBookingHotelHtmlBackendAlias::load_jquery_library('icheck');
ToolBar::setTitle("List payment");
WpBookingHotelHtmlBackendAlias::load_jquery_library('datatables');
?>
<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendGoToLink("payment.form")) ?>" name="admin-form" method="post">
        <div class="view-list-payment">
            <table id="example" class="display table">
                <thead>
                    <tr>
                        <th><?php esc_html_e('Index','wpbookinghotel'); ?></th>
                        <th class="view-list-payment-th nowrap"><?php esc_html_e('Name','wpbookinghotel') ?></th>
                        <th class="view-list-payment-th nowrap"><?php esc_html_e('Image','wpbookinghotel') ?></th>
                        <th class="view-list-payment-th nowrap"><?php esc_html_e('Payment type','wpbookinghotel') ?></th>
                        <th class="view-list-payment-th nowrap"><?php esc_html_e('ID','wpbookinghotel') ?></th>
                        <th class="view-list-payment-th nowrap"><?php esc_html_e('Status','wpbookinghotel') ?></th>
                        <th class="nowrap"></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item){?>
                    <tr>
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                        <td class="name nowrap"><?php echo (esc_html($item->name)) ?></td>
                        <td class="image nowrap">
                            <div class="img-box">
                                <img class="payment-image" src="<?php echo (esc_attr(FactoryAlias::getRootUrlPlugin())) ?>/<?php echo (esc_attr($item->image)) ?>" alt="payment-image" />
                            </div>
                        </td>
                        <td class="name nowrap"><?php echo (esc_html($item->type)) ?></td>
                        <td class="id nowrap"><?php echo (esc_html($item->id)) ?></td>
                        <td class="nowrap">
                            <?php if ($item->published == 1) { ?>
                                <div class="published">
                                    <i class="fas fa-check-square" title="<?php esc_attr_e('Public','wpbookinghotel') ?> "></i>
                                </div>
                            <?php } else { ?>
                                <div class="unpublished">
                                    <i class="far fa-times-circle" title="<?php esc_attr_e('Not public','wpbookinghotel') ?> "></i>
                                </div>
                            <?php } ?>
                        </td>
                        <td class="payment-action">
                            <a href="<?php echo(UtilityAlias::getBackendGoToLink("payment.form",array('id'=>$item->id))) ?>" class="btn-edit" title="<?php esc_attr_e('Edit','wpbookinghotel')?>"><i class="fas fa-edit"></i></a>
                            <a href="<?php echo(UtilityAlias::goToTaskByView("payment","payment.delete",array('id'=>$item->id))) ?>" class="btn-delete" title="<?php esc_attr_e('Delete','wpbookinghotel')?>"><i class="fas fa-trash-alt"></i></a>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="">
    </form>
<?php
$doc->addLessStyleSheet('admin/app/assets/less/view_list_payment.less');
$doc->addStyleSheet('admin/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.view-list-payment', 'view_list_payment', array(

), "admin/app/assets/js/view_list_payment.js");
?>