<?php

use WpBookingHotel\Factory;
use WpBookingHotelAdmin\app\HtmlCustomField\HtmlCustomFieldBackend;

$doc = Factory::getDocument();
$doc->addStyleSheet('admin/app/assets/nb-font-icon/nb-font-icon.css');

?>
<div id="view-payment-block" class="view-payment-form">
    <form action="" method="post" name="admin-form" enctype="multipart/form-data">
        <div>
            <ul class="state-tab nav nav-tabs" role="tablist">
                <li role="presentation" class="active">
                    <a href="#detail" aria-controls="detail" role="tab" data-toggle="tab">
                        <?php esc_html_e('Payment details','wpbookinghotel') ?>
                    </a>
                </li>
                <li role="presentation">
                    <a href="#settings" aria-controls="settings" role="tab" data-toggle="tab">
                        <?php esc_html_e('Payments setting','wpbookinghotel') ?>
                    </a>
                </li>
                <li role="presentation"><a href="#customize" aria-controls="customize" role="tab"
                                           data-toggle="tab"><?php esc_html_e('Customize','wpbookinghotel') ?></a></li>
            </ul>
            <div class="tab-content">
                <div role="tabpanel" class="tab-pane active" id="detail">
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo($this->form->renderField('image')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo($this->form->renderField('name')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo($this->form->renderField('published')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo($this->form->renderField('debug')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo($this->form->renderField('is_payment_online')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo($this->form->renderField('description')) ?>
                        </div>
                    </div>
                </div>
                <div role="tabpanel" class="tab-pane" id="settings">
                    <?php
                    $type = $this->item->type;
                    $this->element = new stdClass();
                    $this->element->payment_params = $this->item->params->get('payment_params', "");
                    $configuration_file = WPBOOKINGHOTEL_PATH_ROOT . "lib/payments/$type/{$type}_configuration.php";
                    ?>
                    <?php if (file_exists($configuration_file)) { ?>
                        <table class="table table-bordered">
                            <?php require_once $configuration_file ?>
                        </table>
                    <?php } ?>
                </div>
                <div role="tabpanel" class="tab-pane" id="customize">
                    <?php
                    foreach ($this->list_customize as $customize) {
                        echo (HtmlCustomFieldBackend::render_by_type($customize));
                    }

                    ?>
                </div>
            </div>
        </div>
		<?php echo ($this->form->renderField('id')) ?>
        <input type="hidden" name="task" value="state.save">
    </form>
</div>
