<?php

use WpBookingHotel\Factory as FactoryAlias;
use WpBookingHotel\Html\ToolBar;
use WpBookingHotel\Html\WpBookingHotelHtmlBackend as WpBookingHotelHtmlBackendAlias;
use WpBookingHotel\Utilities\Utility as UtilityAlias;
use WpBookingHotel\Language\Text;
use WpBookingHotelAdmin\app\Html\HtmlBackend;

$doc = FactoryAlias::getDocument();
WpBookingHotelHtmlBackendAlias::load_jquery_library('icheck');
ToolBar::setTitle("List order status");
WpBookingHotelHtmlBackendAlias::load_jquery_library('datatables');
?>
<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendGoToLink("orderstatus.form")) ?>" name="admin-form" method="post">
        <div class="view-list-orderstatus">
            <table id="example" class="display table">
                <thead>
                    <tr>
                        <th><?php esc_html_e('Index','wpbookinghotel'); ?></th>
                        <th class="name-order-status nowrap"><?php esc_html_e('Name','wpbookinghotel') ?></th>
                        <th class="id-order-status nowrap"><?php esc_html_e('ID','wpbookinghotel') ?></th>
                        <th class="ordering-order-status nowrap"><?php esc_html_e('Ordering','wpbookinghotel') ?></th>
                        <th class="nowrap"></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item){?>
                    <tr>
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                        <td class="name nowrap"><?php esc_html_e($item->name,'wpbookinghotel'); ?></td>
                        <td class="id nowrap"><?php echo (esc_html($item->id)); ?></td>
                        <td class="ordering nowrap"><?php echo (esc_html($item->ordering)); ?></td>
                        <td class="orderstatus-action">
                            <a href="<?php echo(UtilityAlias::getBackendGoToLink("orderstatus.form",array('id'=>$item->id))) ?>" class="btn-edit" title="<?php esc_attr_e('Edit','wpbookinghotel')?>"><i class="fas fa-edit"></i></a>
                            <a href="<?php echo(UtilityAlias::goToTaskByView("orderstatus","orderstatus.delete",array('id'=>$item->id))) ?>" class="btn-delete" title="<?php esc_attr_e('Delete','wpbookinghotel')?>"><i class="fas fa-trash-alt"></i></a>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="">
    </form>
<?php
$doc->addLessStyleSheet('admin/app/assets/less/view_list_orderstatus.less');
$doc->addStyleSheet('admin/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.view-list-orderstatus', 'view_list_orderstatus', array(

), "admin/app/assets/js/view_list_orderstatus.js");
?>