<?php

namespace WpBookingHotelAdmin\app\views\orderstatus;

use WpBookingHotel\Html\ToolBar;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Mvc\View\View;
use WpBookingHotel\Factory as FactoryAlias;
use WpBookingHotelAdmin\app\helpers\CustomizeHelper;

class OrderstatusView extends View
{
    public function display($tpl)
    {
        $modelorderstatus = Model::getInstance("orderstatus");
        $input = FactoryAlias::getInput();
        switch ($tpl) {
            case "list":
                ToolBar::add("orderstatus.add");
                ToolBar::delete("orderstatus.delete_list");
                ToolBar::_clone("orderstatus.clone_list");
                $model = Model::getInstance("orderstatuss");
                $this->list = $model->getList();
                break;
            case "form":
                ToolBar::setTitle('Edit orderstatus');
                ToolBar::apply("orderstatus.apply");
                ToolBar::save("orderstatus.save");
                ToolBar::cancel("orderstatus.cancel");
                ToolBar::back_to_list("orderstatus.back_to_list");
                $id = $input->getInt('id', 0);
                $this->item = $modelorderstatus->getItem($id);
                $this->form = $modelorderstatus->getForm();
                $this->list_customize=CustomizeHelper::get_list_customize("order_status");
                $this->list_customize=CustomizeHelper::assignValue( $this->list_customize,$this->item);
                break;
        }
        return parent::display($tpl);
    }
}