<?php
use WpBookingHotel\Factory as FactoryAlias;
use WpBookingHotel\Html\ToolBar;
use WpBookingHotel\Html\WpBookingHotelHtmlBackend as WpBookingHotelHtmlBackendAlias;
use WpBookingHotel\Utilities\Utility as UtilityAlias;
use WpBookingHotelAdmin\app\Html\HtmlBackend;
use WpBookingHotel\Language\Text;
$doc = FactoryAlias::getDocument();
$doc->addLessStyleSheet('admin/app/assets/less/view_list_orders.less');
WpBookingHotelHtmlBackendAlias::load_jquery_library('icheck');
ToolBar::setTitle("List order");
WpBookingHotelHtmlBackendAlias::load_jquery_library('datatables');
?>
<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendGoToLink("orders.form")) ?>" name="admin-form" method="post">
        <div class="view-list-orders">
            <table id="example" class="display table">
                <thead>
                    <tr>
                        <th><?php esc_html_e('Index','wpbookinghotel'); ?></th>
                        <th><?php esc_html_e('Order number','wpbookinghotel'); ?></th>
                        <th><?php esc_html_e('Customer','wpbookinghotel'); ?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item){?>
                    <tr>
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id))?></td>
                        <td class="order-number"><?php echo (esc_html($item->id)); ?></td>
                        <td class="customer"><?php echo (esc_html($item->customer_full_name)); ?></td>
                        <td class="order-action">
                            <a href="<?php echo(UtilityAlias::getBackendGoToLink("orders.form",array('id'=>$item->id))) ?>" class="btn-edit" title="<?php esc_attr_e('Edit','wpbookinghotel')?>"><i class="fas fa-edit"></i></a>
                            <a href="<?php echo(UtilityAlias::goToTaskByView("orders","order.delete",array('id'=>$item->id))) ?>" class="btn-delete" title="<?php esc_attr_e('Delete','wpbookinghotel')?>"><i class="fas fa-trash-alt"></i></a>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="tour.add">
    </form>
<?php
$doc->addStyleSheet('admin/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.view-list-orders', 'view_list_orders', array(

), "admin/app/assets/js/view_list_orders.js");
?>