<?php

use WpBookingHotel\Factory;
use WpBookingHotel\Language\Text;
use WpBookingHotelAdmin\app\Html\HtmlBackend;

$doc = Factory::getDocument();
$doc->addStyleSheet('admin/app/assets/nb-font-icon/nb-font-icon.css');
$order_detail = reset($this->item->list_order_detail);
?>
<div class="view-order-form">
    <form action="" name="admin-form" method="post" enctype="multipart/form-data">
        <table class="table table-bordered">
            <tr>
                <th width="40%"><?php esc_html_e('Order id','wpbookinghotel'); ?></th>
                <td><?php esc_html_e($this->item->id); ?></td>
            </tr>
            <tr>
                <th><?php esc_html_e('Customer name','wpbookinghotel'); ?></th>
                <td><?php echo (isset($this->item->customer->full_name)?$this->item->customer->full_name:''); ?></td>
            </tr>
            <tr>
                <th><?php esc_html_e('Hotel name','wpbookinghotel'); ?></th>
                <td><?php echo (isset($this->item->hotel->name)?$this->item->hotel->name:''); ?></td>
            </tr>
            <tr>
                <th><?php esc_html_e('Check in','wpbookinghotel'); ?></th>
                <td><?php echo (isset($order_detail->order_detail_rate->check_in)?HtmlBackend::render_date($order_detail->order_detail_rate->check_in):''); ?></td>
            </tr>
            <tr>
                <th><?php esc_html_e('Check out','wpbookinghotel'); ?></th>
                <td><?php echo (isset($order_detail->order_detail_rate->check_out)?HtmlBackend::render_date($order_detail->order_detail_rate->check_out):''); ?></td>
            </tr>
            <tr>
                <th><?php esc_html_e('Adult','wpbookinghotel'); ?></th>
                <td><?php echo (isset($order_detail->order_detail_rate->number_adult)?$order_detail->order_detail_rate->number_adult:''); ?></td>
            </tr>
            <tr>
                <th><?php esc_html_e('Children','wpbookinghotel'); ?></th>
                <td><?php echo (isset($order_detail->order_detail_rate->number_child)?$order_detail->order_detail_rate->number_child:''); ?></td>
            </tr>
            <tr>
                <th><?php esc_html_e('Change order status','wpbookinghotel'); ?></th>
                <td>
                    <?php
                    $field = $this->form->getField('order_status_id');
                    ?>
                    <?php echo ($field->input) ?>

                </td>
            </tr>
        </table>

        <?php echo ($this->form->renderField('id')) ?>
    </form>
</div>
