<?php

use WpBookingHotel\Factory;
use WpBookingHotel\Language\Text;
use WpBookingHotelAdmin\app\HtmlCustomField\HtmlCustomFieldBackend;


$doc = Factory::getDocument();
$doc->addStyleSheet('admin/app/assets/nb-font-icon/nb-font-icon.css');
?>
<div class="view-hotel-form">
    <form action="" method="post" name="admin-form" enctype="multipart/form-data">

        <div>
            <ul class="state-tab nav nav-tabs" role="tablist">
                <li role="presentation" class="active"><a href="#detail" aria-controls="detail" role="tab"
                                                          data-toggle="tab"> <?php esc_html_e('Hotel details','wpbookinghotel') ?></a></li>
                <li role="presentation"><a href="#gallery" aria-controls="gallery" role="tab"
                                                          data-toggle="tab"> <?php esc_html_e('Gallery','wpbookinghotel') ?></a></li>
                <li role="presentation"><a href="#customize" aria-controls="customize" role="tab"
                                           data-toggle="tab"><?php esc_html_e('Customize','wpbookinghotel') ?></a></li>
                <li role="presentation"><a href="#background_img" aria-controls="background_img" role="tab" data-toggle="tab"><?php esc_html_e('Background','wpbookinghotel') ?></a></li>


            </ul>
            <div class="tab-content">
                <div role="tabpanel" class="tab-pane active" id="detail">
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo($this->form->renderField('image')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo($this->form->renderField('name')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo($this->form->renderField('alias')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo($this->form->renderField('meta_keyword')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo($this->form->renderField('meta_description')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo($this->form->renderField('destination')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('email')) ?>
                        </div>
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('phone_number')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('max_adult')) ?>
                        </div>
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('max_child')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo($this->form->renderField('price')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo($this->form->renderField('rate')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo($this->form->renderField('room_type_id')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo($this->form->renderField('service')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo($this->form->renderField('tag')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('facebook','params')) ?>
                        </div>
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('instagram','params')) ?>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <?php echo($this->form->renderField('published')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo($this->form->renderField('description')) ?>
                        </div>
                    </div>
                </div>
                <div role="tabpanel" class="tab-pane" id="gallery">
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo($this->form->renderField('gallery')) ?>
                        </div>
                    </div>
                </div>
                <div role="tabpanel" class="tab-pane" id="customize">
                    <?php
                    foreach ($this->list_customize as $customize) {
                        echo (HtmlCustomFieldBackend::render_by_type($customize));
                    }

                    ?>
                </div>
                <div role="tabpanel" class="tab-pane" id="background_img">
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo($this->form->renderField('background_img')) ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
		<?php echo ($this->form->renderField('id')) ?>
        <input type="hidden" name="task" value="state.save">
    </form>
</div>
