<?php

namespace WpBookingHotelAdmin\app\views\hotel;

use WpBookingHotel\Html\ToolBar;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Mvc\View\View;
use WpBookingHotel\Factory as FactoryAlias;
use WpBookingHotelAdmin\app\helpers\CustomizeHelper;

class HotelView extends View
{
    public function display($tpl)
    {
        $modelhotel = Model::getInstance("hotel");
        $input = FactoryAlias::getInput();
        switch ($tpl) {
            case "list":
                ToolBar::add("hotel.add");
                ToolBar::delete("hotel.delete_list");
                ToolBar::_clone("hotel.clone_list");
                $model = Model::getInstance("hotels");
                $this->list = $model->getList();
                break;
            case "form":
                ToolBar::setTitle('Edit hotel');
                ToolBar::apply("hotel.apply");
                ToolBar::save("hotel.save");
                ToolBar::cancel("hotel.cancel");
                ToolBar::back_to_list("hotel.back_to_list");
                $id = $input->getInt('id', 0);
                $this->item = $modelhotel->getItem($id);
                $this->form = $modelhotel->getForm();
                $this->list_customize=CustomizeHelper::get_list_customize("hotel");
                $this->list_customize=CustomizeHelper::assignValue( $this->list_customize,$this->item);
                break;
        }
        return parent::display($tpl);
    }
}