<?php

namespace WpBookingHotelAdmin\app\views\discount;

use WpBookingHotel\Html\ToolBar;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Mvc\View\View;
use WpBookingHotel\Factory as FactoryAlias;
use WpBookingHotelAdmin\app\helpers\CustomizeHelper;

class DiscountView extends View
{
    public function display($tpl)
    {

        $modelDiscount = Model::getInstance("discount");
        $input = FactoryAlias::getInput();
        switch ($tpl) {
            case "list":
                ToolBar::add("discount.add");
                ToolBar::delete("discount.delete_list");
                ToolBar::_clone("discount.clone_list");
                $model = Model::getInstance("discounts");
                $this->list = $model->getList();
                break;
            case "form":
                ToolBar::setTitle('Edit discount');
                ToolBar::apply("discount.apply");
                ToolBar::save("discount.save");
                ToolBar::cancel("discount.cancel");
                ToolBar::back_to_list("discount.back_to_list");
                $id = $input->getInt('id', 0);
                $this->item = $modelDiscount->getItem($id);
                $this->form = $modelDiscount->getForm();
                $this->list_customize=CustomizeHelper::get_list_customize("discount");
                $this->list_customize=CustomizeHelper::assignValue( $this->list_customize,$this->item);

                break;
        }
        return parent::display($tpl);
    }
}