<?php

use WpBookingHotel\Factory;
use WpBookingHotel\Html\WpBookingHotelHtmlBackend;
use WpBookingHotel\Utilities\Utility;
use WpBookingHotel\Language\Text;
use WpBookingHotelAdmin\app\Html\HtmlBackend;

$doc = Factory::getDocument();
WpBookingHotelHtmlBackend::load_jquery_library('chart_js');
WpBookingHotelHtmlBackend::load_jquery_library('bootstrap_tabs');
$doc->addLessStyleSheet('admin/app/assets/less/view_db_appointments_dashboard.less');
$number_user= count((array)$this->list_customer);
$number_month=count((array)$this->list_order_by_month);
$number_month_order=count((array)$this->list_order_by_month,1);
$number_oder= $number_month_order - $number_month;
$number_hotels= count((array)$this->list_hotels);
$total=0;
?>
    <div class="view-db-appointments-dashboard">
        <h2 class="title"><i class="fab fa-buromobelexperte"></i> <?php esc_html_e('WordPress Booking Hotel','wpbookinghotel') ?></h2>
        <div class="row">
            <div class="col-md-3">
                <div class="block-item-widget user">
                    <div class="icon-block">
                        <i class="fas fa-user-friends"></i>
                    </div>
                    <div class="content-block">
                        <h4> <?php esc_html_e('New users','wpbookinghotel') ?></h4>
                        <p><?php echo ($number_user?$number_user:0); ?> <?php esc_html_e('New users','wpbookinghotel') ?></p>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="block-item-widget order">
                    <div class="icon-block">
                        <i class="fas fa-cart-plus"></i>
                    </div>
                    <div class="content-block">
                        <h4><?php esc_html_e('New orders','wpbookinghotel') ?></h4>
                        <p><?php esc_html_e($number_oder);  ?> <?php esc_html_e('new orders','wpbookinghotel') ?></p>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="block-item-widget delivery">
                    <div class="icon-block">
                        <i class="fas fa-shopping-bag"></i>
                    </div>
                    <div class="content-block">
                        <h4><?php esc_html_e('Hotels','wpbookinghotel') ?></h4>
                        <p><?php esc_html_e($number_hotels);  ?> <?php esc_html_e('hotels','wpbookinghotel') ?></p>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="block-item-widget monthly">
                    <div class="icon-block">
                        <i class="fas fa-dollar-sign"></i>
                    </div>
                    <div class="content-block">
                        <?php foreach ($this->list_order_in_year as $item) { ?>
                            <?php $total += $item->total ?>
                        <?php } ?>
                        <h4><?php esc_html_e('Yearly profits','wpbookinghotel') ?></h4>
                        <p><?php echo (HtmlBackend::render_price($total)); ?> <?php esc_html_e('This year','wpbookinghotel') ?></p>
                    </div>
                </div>
            </div>

        </div>
        <div class="total-order">
            <h3><?php esc_html_e('Total order','wpbookinghotel') ?></h3>
            <canvas class="order-this-week"></canvas>
        </div>
        <div class="monthly-profits">
            <h3><?php esc_html_e('Month profits','wpbookinghotel') ?></h3>
            <canvas class="employee-chart"></canvas>
        </div>
        <div class="row">
            <div class="col-md-6">
                <div class="new-customer">
                    <h3><?php esc_html_e('New customer','wpbookinghotel') ?></h3>
                    <table class="table table-responsive">
                        <thead>
                        <tr>
                            <th class="nowrap"><?php esc_html_e('Id','wpbookinghotel') ?></th>
                            <th class="nowrap"><?php esc_html_e('Name','wpbookinghotel') ?></th>
                            <th class="nowrap"><?php esc_html_e('Phone','wpbookinghotel') ?></th>
                            <th class="nowrap"><?php esc_html_e('Order time','wpbookinghotel') ?> </th>
                        </tr>
                        </thead>
                        <tbody class="list-wbcustomer main-table">
                        <?php foreach ($this->list_customer as $item) { ?>
                            <?php $this->item = $item ?>
                            <?php $this->loadTemplate('list_item_customer') ?>
                        <?php } ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="col-md-6">
                <div class="list-hotel">
                    <h3><?php esc_html_e('List Hotels','wpbookinghotel') ?></h3>
                    <table class="table table-responsive">
                        <thead>
                        <tr>
                            <th class="view-list-category-th nowrap"><?php esc_html_e('Id','wpbookinghotel') ?></th>
                            <th class="view-list-category-th nowrap"><?php esc_html_e('Name','wpbookinghotel') ?></th>
                            <th class="view-list-category-th nowrap"><?php esc_html_e('Image','wpbookinghotel') ?></th>
                        </tr>
                        </thead>
                        <tbody class="list-category main-table">
                        <?php foreach ($this->list_hotels as $item) { ?>
                            <?php $this->item = $item ?>
                            <?php $this->loadTemplate('list_item_hotel') ?>
                        <?php } ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php
$doc->addScriptApplySelector('.view-db-appointments-dashboard','view_db_appointments_dashboard',array(
    "list_order_by_month"=>$this->list_order_by_month
),'admin/app/assets/js/view_db_appointments_dashboard.js');