<?php

use WpBookingHotel\Factory as FactoryAlias;
use WpBookingHotel\Html\ToolBar;
use WpBookingHotel\Html\WpBookingHotelHtmlBackend as WpBookingHotelHtmlBackendAlias;
use WpBookingHotel\Language\Text;
use WpBookingHotel\Utilities\Utility as UtilityAlias;
use WpBookingHotelAdmin\app\Html\HtmlBackend;
$doc = FactoryAlias::getDocument();
$doc->addLessStyleSheet('admin/app/assets/less/view_list_customers.less');
WpBookingHotelHtmlBackendAlias::load_jquery_library('icheck');
ToolBar::setTitle("List Customer");
WpBookingHotelHtmlBackendAlias::load_jquery_library('datatables');
?>
<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendGoToLink("customers.form")) ?>" name="admin-form" method="post">
        <div class="view-list-customers">
            <table id="example" class="display table">
                <thead>
                    <tr>
                        <th><?php esc_html_e('Index','wpbookinghotel'); ?></th>
                        <th><?php esc_html_e('Customer name','wpbookinghotel'); ?></th>
                        <th><?php esc_html_e('Phone','wpbookinghotel'); ?></th>
                        <th><?php esc_html_e('Birthday','wpbookinghotel'); ?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item){?>
                    <tr>
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id))?></td>
                        <td class="customer-name"><?php echo ($item->first_name); ?> <?php echo ($item->last_name); ?></td>
                        <td class="customer-phone">
                            <?php
                            $phone = isset($item->phone)?$item->phone:'';
                            if($phone['0'] == 0) {
                                $phone = substr($phone,1);
                            }
                            $phonecode = isset($item->phonecode)?$item->phonecode:'';
                            echo (esc_html('+'.$phonecode . $phone));
                            ?>
                        </td>
                        <td class="customer-birthday"><?php echo ($item->birth_day); ?></td>
                        <td class="customer-action">
                            <a href="<?php echo(UtilityAlias::getBackendGoToLink("customers.form",array('id'=>$item->id))) ?>" class="btn-edit" title="<?php esc_attr_e('Edit','wpbookinghotel')?>"><i class="fas fa-edit"></i> </a>
                            <a href="<?php echo(UtilityAlias::goToTaskByView("customers","customer.delete",array('id'=>$item->id))) ?>" class="btn-delete" title="<?php esc_attr_e('Delete','wpbookinghotel')?>"><i class="fas fa-trash-alt"></i></a>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="customer.save">
    </form>
<?php
$doc->addScriptApplySelector('.view-list-customers', 'view_list_customers', array(), "admin/app/assets/js/view_list_customers.js");
$doc->addStyleSheet('admin/app/assets/nb-font-icon/nb-font-icon.css');
?>