<?php

use WpBookingHotel\Factory as FactoryAlias;
use WpBookingHotel\Html\ToolBar;
use WpBookingHotel\Html\WpBookingHotelHtmlBackend as WpBookingHotelHtmlBackendAlias;
use WpBookingHotel\Utilities\Utility as UtilityAlias;
use WpBookingHotel\Language\Text;
use WpBookingHotelAdmin\app\Html\HtmlBackend;

$doc = FactoryAlias::getDocument();
WpBookingHotelHtmlBackendAlias::load_jquery_library('icheck');
ToolBar::setTitle("List countries");
WpBookingHotelHtmlBackendAlias::load_jquery_library('datatables');
?>
<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendGoToLink("countries.form")) ?>" name="admin-form" method="post">
        <div class="view-list-countries">
            <table id="example" class="display table">
                <thead>
                    <tr>
                        <th><?php esc_html_e('Index','wpbookinghotel'); ?></th>
                        <th><?php esc_html_e('Country name','wpbookinghotel'); ?></th>
                        <th><?php esc_html_e('Country code','wpbookinghotel'); ?></th>
                        <th><?php esc_html_e('Flag','wpbookinghotel'); ?></th>
                        <th><?php esc_html_e('Publish','wpbookinghotel'); ?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item){?>
                    <tr>
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                        <td class="country-name">
                            <h4>
                                <?php echo ($item->countryname); ?>
                            </h4>
                        </td>
                        <td class="country-code"><?php  echo (esc_html($item->countrycode)); ?> </td>
                        <td class="country-flag">
                            <div class="img-box">
                                <div>
                                    <img src="<?php  echo(FactoryAlias::getRootUrlPlugin().'/'.$item->image) ?>" alt="flag">
                                </div>
                            </div>
                        </td>
                        <td class="country-published">
                            <?php if ($item->published == 1) { ?>
                                <div class="published">
                                    <i class="fas fa-check-square" title="Public"></i>
                                </div>
                            <?php } else { ?>
                                <div class="unpublished">
                                    <i class="far fa-times-circle" title="Not-Public"></i>
                                </div>
                            <?php } ?>
                        </td>
                        <td class="country-action">
                            <a href="<?php echo(UtilityAlias::getBackendGoToLink("countries.form",array('id'=>$item->id))) ?>" class="btn-edit" title="<?php esc_attr_e('Edit','wpbookinghotel')?>"><i class="fas fa-edit"></i></a>
                            <a href="<?php echo(UtilityAlias::goToTaskByView("countries","countries.delete",array('id'=>$item->id))) ?>" class="btn-delete" title="<?php esc_attr_e('Delete','wpbookinghotel')?>"><i class="fas fa-trash-alt"></i></a>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="">
    </form>
<?php
$doc->addLessStyleSheet('admin/app/assets/less/view_list_countries.less');
$doc->addStyleSheet('admin/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.view-list-countries', 'view_list_countries', array(

), "admin/app/assets/js/view_list_countries.js");
?>