<?php

use WpBookingHotel\Factory;
use WpBookingHotel\Language\Text;

$doc = Factory::getDocument();
$doc->addStyleSheet('admin/app/assets/nb-font-icon/nb-font-icon.css');
?>
<div class="view-countries-form">
    <form action="" method="post" name="admin-form" enctype="multipart/form-data">

        <div>
            <ul class="state-tab nav nav-tabs" role="tablist">
                <li role="presentation" class="active"><a href="#home" aria-controls="home" role="tab"
                                                          data-toggle="tab"> <?php esc_html_e('Country details','wpbookinghotel') ?></a></li>
                <li role="presentation"><a href="#gallery" aria-controls="gallery" role="tab"
                                                          data-toggle="tab"> <?php esc_html_e('Gallery','wpbookinghotel') ?></a></li>
            </ul>
            <div class="tab-content">
                <div role="tabpanel" class="tab-pane active" id="home">
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo ($this->form->renderField('image')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo ($this->form->renderField('countries')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo ($this->form->renderField('countrycode')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo ($this->form->renderField('code')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php
                            $field = $this->form->getField('published')
                            ?>
                            <?php echo ($field->input) ?>
                        </div>
                    </div>
                </div>
                <div role="tabpanel" class="tab-pane" id="gallery">
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo($this->form->renderField('gallery')) ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
		<?php echo ($this->form->renderField('id')) ?>
        <input type="hidden" name="task" value="country.save">
    </form>
</div>
