<?php

use WpBookingHotel\Factory;
use WpBookingHotel\Html\ToolBar;
use WpBookingHotel\Language\Text;
$doc = Factory::getDocument();
$doc->addStyleSheet('admin/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addLessStyleSheet('admin/app/assets/less/view_form_config.less');
?>
<div class="view-config-form">
    <form action="" name="admin-form" method="post">
        <div>
            <ul class="event-tab nav nav-tabs" role="tablist">
                <li role="presentation" class="active"><a href="#basic" aria-controls="home" role="tab"
                                                          data-toggle="tab"><?php esc_html_e('Basic','wpbookinghotel') ?></a></li>
                <li role="presentation"><a href="#booking" aria-controls="profile" role="tab"
                                           data-toggle="tab"><?php esc_html_e("Booking",'wpbookinghotel') ?></a></li>
            </ul>
            <div class="tab-content">
                <div role="tabpanel" class="tab-pane active" id="basic">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="block-basic-item">
                                <?php echo ($this->form->renderField('page_hotel_detail','params')) ?>
                                <?php echo(ToolBar::render_button_task("config.create_page_hotel_detail",wpbookinghotel_get_content("Create page hotel detail"))) ?>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="block-basic-item">
                                <?php echo ($this->form->renderField('page_list_hotel','params')) ?>
                                <?php echo(ToolBar::render_button_task("config.create_page_list_hotel",wpbookinghotel_get_content("Create page list hotel"))) ?>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="block-basic-item">
                                <?php echo ($this->form->renderField('page_checkout_default','params')) ?>
                                <?php echo(ToolBar::render_button_task("config.create_page_checkout",wpbookinghotel_get_content("Create page checkout"))) ?>
                            </div>
                        </div>
                    </div>

                    <div class="clearfix"></div>
                </div>
                <div role="tabpanel" class="tab-pane" id="booking">
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo($this->form->renderField('booking_style','params')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php
                            $field = $this->form->getField('multi_product_in_cart','params');
                            echo ($field->input)
                            ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php
                            $field = $this->form->getField('is_enable_send_sms','params');
                            echo ($field->input)
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <input type="hidden" name="task" value="config.save">
    </form>
</div>
