<?php

namespace WpBookingHotelAdmin\app\views\activities;

use WpBookingHotel\Html\ToolBar;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Mvc\View\View;
use WpBookingHotel\Factory as FactoryAlias;
use WpBookingHotelAdmin\app\helpers\CustomizeHelper;

class ActivitiesView extends View
{
    public function display($tpl)
    {
        $modelActivity = Model::getInstance("activity");
        $input = FactoryAlias::getInput();
        switch ($tpl) {
            case "list":
                ToolBar::add("activity.add");
                ToolBar::delete("activity.delete_list");
                ToolBar::_clone("activity.clone_list");
                $model = Model::getInstance("activities");
                $this->list = $model->getList();
                break;
            case "form":
                ToolBar::setTitle('Edit Activity');
                ToolBar::apply("activity.apply");
                ToolBar::save("activity.save");
                ToolBar::cancel("activity.cancel");
                ToolBar::back_to_list("activity.back_to_list");
                $id = $input->getInt('id', 0);
                $this->item = $modelActivity->getItem($id);
                $this->form = $modelActivity->getForm();
                $this->list_customize=CustomizeHelper::get_list_customize("activity");
                $this->list_customize=CustomizeHelper::assignValue( $this->list_customize,$this->item);

                break;
        }
        return parent::display($tpl);
    }
}