<?php
namespace WpBookingHotelAdmin\app\models;
defined('_WPBOOKINGHOTEL_EXEC') or die;

use Exception;
use WpBookingHotel\Factory;
use WpBookingHotel\Language\Text;
use WpBookingHotel\Mvc\Model\ModelForm;
use WpBookingHotel\Filesystem\File as FileAlias;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Form\Form;
use WpBookingHotel\Mvc\Model\ModelList;
use WpBookingHotel\Registry\Registry;
use WpBookingHotel\Utilities\Utility;

class SmsModel extends ModelForm
{
    /**
     * @var string
     */
    public $context = "sms";
    /**
     * @var string
     */
    public $table_name = "sms";
    public function save($data = array())
    {
        $query = $this->_db->getQuery(true);
        if($data['published'] == 1) {
            $query->update($this->getTableName('sms'))
                ->set('published=0')
                ;
            $this->_db->setQuery($query)->execute();
        }
        $item =  parent::save($data); // TODO: Change the autogenerated stub
        if($item->published == 1) {
            $query->clear()
                ->update($this->getTableName('smscontent'). ' AS smscontent')
                ->set('smscontent.sms_suplier_id='.(int)$item->id)
            ;
            $this->_db->setQuery($query)->execute();
        }

        return $item;
    }
    public function getItem($id = 0)
    {
        $sms =  parent::getItem($id); // TODO: Change the autogenerated stub
        $query = $this->_db->getQuery(true);
        if(!empty((array)$sms)) {
            $query->clear()
                ->select('country.countryname')
                ->from($this->getTableName('country').' AS country')
                ->where('country.phonecode='.(int)$sms->phonecode)
                ->where('country.countrycode='.$query->quote($sms->countrycode))
            ;
            $sms->country_name = $this->_db->setQuery($query)->loadResult();
        }
        return $sms;
    }


}
