<?php
namespace WpBookingHotelAdmin\app\models;
defined('_WPBOOKINGHOTEL_EXEC') or die;

use WpBookingHotel\Factory;
use WpBookingHotel\Mvc\Model\ModelForm;
use WpBookingHotel\Filesystem\File as FileAlias;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Form\Form;
use WpBookingHotel\Mvc\Model\ModelList;
use WpBookingHotel\Registry\Registry;
use WpBookingHotel\Utilities\Utility;

class OrderModel extends ModelForm
{
    /**
     * @var string
     */
    public $context = "order";
    /**
     * @var string
     */
    public $table_name = "order";

    public function getItem($id = 0)
    {
        $item= parent::getItem($id); // TODO: Change the autogenerated stub
        if(isset($item->id) && $item->id !=0) {
            $query = $this->db->getQuery(true);
            $query->clear()
                ->select('order_detail.*')
                ->from($this->getTableName('order_detail') . ' AS order_detail')
                ->where('order_detail.order_id=' . (int)$item->id)
            ;
            $list_order_detail = $this->db->setQuery($query)->loadObjectList();
            foreach ($list_order_detail as &$order_detail) {
                $query->clear()
                    ->select('order_detail_rate.*')
                    ->from($this->getTableName('order_detail_rate'). ' AS order_detail_rate ')
                    ->where('order_detail_rate.order_detail_id='.(int)$order_detail->id)
                    ;
                $order_detail->order_detail_rate = $this->_db->setQuery($query)->loadObject();

                $query->clear()
                    ->select('hotel.*')
                    ->from($this->getTableName('hotel') . ' AS hotel')
                    ->where('hotel.id=' . (int)$order_detail->hotel_id);
                $item->hotel = $this->db->setQuery($query)->loadObject();

            }
            $item->list_order_detail = $list_order_detail;

            $query->clear()
                ->select('customer.*')
                ->from($this->getTableName('customer') . ' AS customer')
                ->where('customer.id=' . (int)$item->customer_id);
            $item->customer = $this->db->setQuery($query)->loadObject();
            if( $item->customer)
            {
                $item->customer->full_name=Utility::get_full_name($item->customer->first_name,$item->customer->last_name);
            }


        }
        return $item;
    }
    public function change_order_status($order_id, $order_status_id)
    {
        $data = array(
            "id" => $order_id,
            "order_status_id" => $order_status_id
        );
        $order = parent::save($data);
        return $order;
    }


}
