<?php
namespace WpBookingHotelAdmin\app\models;
defined('_WPBOOKINGHOTEL_EXEC') or die;

use WpBookingHotel\Factory;
use WpBookingHotel\Mvc\Model\ModelForm;
use WpBookingHotel\Form\Form;
use WpBookingHotel\Mvc\Model\ModelList;
use WpBookingHotel\Registry\Registry;
use WpBookingHotelAdmin\app\helpers\AdminHelper;

class DiscountsModel extends ModelList
{
    /**
     * @var string
     */
    public $context = "discounts";
    /**
     * @var string
     */
    public $table_name = "discount";

    public function getList()
    {
        $list_discount =  parent::getList(); // TODO: Change the autogenerated stub
        foreach ($list_discount as &$discount) {
            $query = $this->_db->getQuery(true);
            $query->clear()
                ->select('DISTINCT hotel.*')
                ->from($this->getTableName('hotel').' AS hotel')
                ->leftJoin($this->getTableName('hotelproperty').' AS hotel_property ON hotel_property.hotel_id=hotel.id')
                ->where('hotel_property.object_id='.(int)$discount->id)
                ->where('hotel_property.type='.$query->quote(AdminHelper::getWpBookingDiscountKey()))
            ;
            $discount->list_hotel=$this->_db->setQuery($query)->loadObjectList();
        }
        return $list_discount;
    }

}
