<?php
namespace WpBookingHotelAdmin\app\models;
defined('_WPBOOKINGHOTEL_EXEC') or die;

use WpBookingHotel\Factory;
use WpBookingHotel\Language\Text;
use WpBookingHotel\Mvc\Model\ModelForm;
use WpBookingHotel\Filesystem\File as FileAlias;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Form\Form;
use WpBookingHotel\Mvc\Model\ModelList;
use WpBookingHotel\Registry\Registry;
use WpBookingHotel\Utilities\Utility;

class CustomizeModel extends ModelForm
{
    /**
     * @var string
     */
    public $context = "customize";
    /**
     * @var string
     */
    public $table_name = "customize";

    public function save($data = array())
    {
        $is_new=!$data["id"];
        $item= parent::save($data); // TODO: Change the autogenerated stub
        if($is_new){
            $db=Factory::getDBO();
            $table=Utility::getTableName($item->table_view);
            switch ($item->type){
                case "boolean":
                    $db->setQuery("ALTER TABLE {$table} ADD `{$item->field_name}` INT NOT NULL;")->execute();
                    break;
                case "select":
                case "text":
                    $db->setQuery("ALTER TABLE {$table} ADD `{$item->field_name}` VARCHAR(255) NOT NULL;")->execute();
                    break;

            }
        }
        return $item;
    }


}
