<?php
namespace WpBookingHotelAdmin\app\models;
defined('_WPBOOKINGHOTEL_EXEC') or die;

use WpBookingHotel\Factory;
use WpBookingHotel\Mvc\Model\ModelForm;
use WpBookingHotel\Form\Form;
use WpBookingHotel\Mvc\Model\ModelList;
use WpBookingHotel\Registry\Registry;
class CountriesModel extends ModelList
{
    /**
     * @var string
     */
    public $context = "countries";
    /**
     * @var string
     */
    public $table_name = "country";
    public function getList()
    {
        $db=Factory::getDBO();
        $query=$this->getListQuery();

        return $db->setQuery($query)->loadObjectList();
    }

    public function getListCountryLocationPopular() {
        $query = $this->_db->getQuery(true);
        $query->select('country.*')
            ->from($this->getTableName('country').' AS country')
            ->leftJoin($this->getTableName('state').' AS state ON state.country_id=country.id')
            ->leftJoin($this->getTableName('location').' AS location ON location.state_id=state.id')
            ->where('location.is_top_destination=1')
            ;
        $list_country = $this->_db->setQuery($query)->loadObjectList();
        return $list_country;
    }


}
