<?php
defined('_WPBOOKINGHOTEL_EXEC') or die;

use WpBookingHotel\Factory;
use WpBookingHotel\Language\Text;
use WpBookingHotel\Utilities\Utility;
use WpBookingHotel\Html\WpBookingHotelHtmlBackend as WpBookingHotelHtmlBackendAlias;
extract($displayData);
WpBookingHotelHtmlBackendAlias::load_jquery_library('select_yes_no');
WpBookingHotelHtmlBackendAlias::load_jquery_library('tooltipster');


$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$name_of_field = str_replace(array('[', ']'), '_', $name);
?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>"
         class="<?php echo (esc_attr($class)); ?> field-yesno-<?php echo (esc_attr($name_of_field)) ?> field-yesno">
        <div class="form-control">
                <div class="block-left">
                    <label><?php esc_html_e($label,'wpbookinghotel') ?></label>
                    <span class="tooltipster" class="fas fa-question-circle"></span>
                </div>
                <div class="block-right">
                    <input class="form-check-input yes-no pull-right" <?php echo ($value == 1 ? ' checked ' : "unchecked") ?>
                           type="checkbox">
                    <input class="" name="<?php echo (esc_attr($name)); ?>" type="hidden"
                           value="<?php echo (esc_attr($value)) ?>">
                </div>
        </div>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin/app/layouts/WooBooking/form/field/yesno/yesno.less');
$doc->addScriptApplySelector('#'.$id_by_name,'field_yesno',array(
    "field_name"=>  $name,
), 'admin/app/layouts/WooBooking/form/field/yesno/yesno.jquery.js');