<?php

use WpBookingHotel\Factory;
use WpBookingHotel\Html\WpBookingHotelHtmlBackend;
use WpBookingHotel\Language\Text;
use WpBookingHotel\Utilities\Utility;
defined('_WPBOOKINGHOTEL_EXEC') or die;
extract($displayData);

WpBookingHotelHtmlBackend::load_jquery_library('dateselect');
WpBookingHotelHtmlBackend::load_jquery_library('select2');

$doc = Factory::getDocument();
$list_open_source_user = get_users();
$id_by_name = "element_field_". $name;
?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="field-wordpress_user">
        <select class="open-source-user" name="<?php echo (esc_attr($name)); ?>">
            <option value=""><?php esc_attr_e('None','wpbookinghotel') ?></option>
			<?php foreach ($list_open_source_user as $user) { ?>
                <option <?php echo ($value == $user->get('ID') ? ' selected ' : '') ?>
                        value="<?php echo($user->get('ID')) ?>"><?php echo ($user->get('user_login')) ?></option>
			<?php } ?>
        </select>
    </div>
<?php
$doc->addLessStyleSheet('admin/app/layouts/WooBooking/form/field/wordpressuser/wordpressuser.less');
$doc->addScriptApplySelector('.field-wordpress_user','field_wordpress_user',array(
    "input_name"=>  $name,
),'admin/app/layouts/WooBooking/form/field/wordpressuser/wordpressuser.jquery.js');
