<?php

use WpBookingHotel\Factory;
use WpBookingHotel\Html\WpBookingHotelHtmlBackend;
use WpBookingHotel\Language\Text;
use WpBookingHotel\Utilities\Utility;
use WpBookingHotelAdmin\app\Html\HtmlBackend;

defined('_WPBOOKINGHOTEL_EXEC') or die;
extract($displayData);

$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$list_selected = $value;
$list_view = HtmlBackend::function_get_view();
WpBookingHotelHtmlBackend::load_jquery_library('icheck');
?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> field-views">
        <ul class=" list-view">
			<?php foreach ($list_view as $view) { ?>
                <li>
                    <label>
                        <input type="checkbox" name="<?php echo (esc_attr($name)); ?>[]" value="<?php echo (esc_attr($view->menu_slug)); ?>" <?php echo ($view->is_system) || in_array($view->menu_slug,
                            $list_selected) ? ' checked ' : '' ?> <?php echo ($view->is_system ? ' disabled ' : '') ?> />
                        <?php esc_html_e($view->label,'wpbookinghotel'); ?>
                    </label>
                </li>
			<?php } ?>
        </ul>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStylesheet('admin/app/layouts/WooBooking/form/field/views/views.less');
$doc->addScriptApplySelector('.field-views','field_views',array(
    "field_name"=>  $name,
),'admin/app/layouts/WooBooking/form/field/views/views.jquery.js');
