<?php

use WpBookingHotel\Factory;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Utilities\Utility;
use WpBookingHotel\Html\WpBookingHotelHtmlBackend as WpBookingHotelHtmlBackendAlias;
use WpBookingHotel\Language\Text;
defined('_WPBOOKINGHOTEL_EXEC') or die;
extract($displayData);

WpBookingHotelHtmlBackendAlias::load_jquery_library('select2');


$id_by_name = "element_field_". $name;
$data = $displayData['field']->getForm()->getData();
$modelStates = Model::getInstance('states');
$list = $modelStates->getList();
?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> field-states">
        <div class="wrapper-state">
            <input class="state" type="text" value="<?php echo (esc_attr($value)) ?>">
            <input type="hidden" name="<?php echo (esc_attr($name)) ?>" value="<?php echo (esc_attr($value)) ?>">
        </div>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin/app/layouts/WooBooking/form/field/states/states.less');
$doc->addScriptApplySelector('.field-states','field_states',array(
    "list_state"=>  $list,
    "input_field"=>  $name,
),'admin/app/layouts/WooBooking/form/field/states/states.jquery.js');