<?php

use WpBookingHotel\Factory;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Utilities\Utility;
use WpBookingHotel\Language\Text;
use WpBookingHotel\Html\WpBookingHotelHtmlBackend as WpBookingHotelHtmlBackendAlias;
defined('_WPBOOKINGHOTEL_EXEC') or die;
extract($displayData);

WpBookingHotelHtmlBackendAlias::load_jquery_library('select2');
WpBookingHotelHtmlBackendAlias::load_jquery_library('auto_numeric');


$id_by_name = "element_field_". $name;
$data = $displayData['field']->getForm()->getData();
$modelservice = Model::getInstance('service');
$list = $modelservice->getList();
$list_time = [];
$list_service_id = [];
if (!is_array($value)) {
	$list_service_id[] = $value;
} else {
	$list_service_id = $value;
}
$modelHotel  = Model::getInstance('hotel');
$input = Factory::getInput();
$hotel_id = $input->getInt('id', 0);
$hotel = $modelHotel->getItem($hotel_id);
$price_service = isset($hotel->price_service)?$hotel->price_service:array();


$tempalte_service = function ($name, $required, $multiple, $list, $service_id, $name_price_service,$price_service) {

    ob_start();
    ?>
    <div class="wrapper-item-service">
        <div class="block-service">
            <select name="<?php echo (esc_attr($name.'[]')); ?>"
                    required="<?php echo (esc_attr($required)) ?>" <?php echo ($multiple ? ' multiple ' : ""); ?>
                    class="list-service">
                <option value=""><?php esc_html_e('Select service','wpbookinghotel') ?></option>
                <?php foreach ($list as $item) { ?>
                    <option <?php echo ($item->id == $service_id ? ' selected ' : null) ?>
                        value="<?php echo (esc_attr($item->id)); ?>"><?php esc_html_e($item->name,'wpbookinghotel'); ?></option>
                <?php } ?>
            </select>
        </div>
        <div class="block-price">
            <input type="text" class="price-service" name="<?php echo (esc_attr($name_price_service.'[]'));?>" value="<?php echo (esc_attr($price_service));?>" placeholder="<?php esc_attr_e('Service price','wpbookinghotel');?>">
        </div>
        <div class="button-action">
            <button type="button" class="btn btn-primary btn-add-service"><i class="far fa-copy"></i></button>
            <button type="button" class="btn btn-danger btn-delete-service"><i class="far fa-trash-alt"></i></button>
        </div>
    </div>
    <?php
    $content = ob_get_clean();
    return $content;
};


?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> field-servicewithprice">
        <?php if(count($list_service_id) == 0) {
            echo ($tempalte_service($name, $required, $multiple, $list, null, $name_price_service,null));
        } elseif (count($list_service_id) == 1 && trim($list_service_id['0']) == '') {
            echo ($tempalte_service($name, $required, $multiple, $list, null, $name_price_service,null));
        } else {

            foreach ($list_service_id as $key => $service_id) {
                echo ($tempalte_service($name, $required, $multiple, $list, $service_id,$name_price_service, $price_service[$key]));
            }
        }

        ?>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin/app/layouts/WooBooking/form/field/servicewithprice/servicewithprice.less');
$doc->addScriptApplySelector("#$id_by_name",'field_servicewithprice',array(
    "values"=>  $value,
    "item_service"=>$tempalte_service($name, $required, $multiple, $list, null, $name_price_service,null),
    "max_service"=> 6,
),'admin/app/layouts/WooBooking/form/field/servicewithprice/servicewithprice.jquery.js');