<?php
use WpBookingHotel\Factory;
use WpBookingHotel\Html\WpBookingHotelHtmlFrontend;
use WpBookingHotel\Language\Text;
use WpBookingHotel\Mvc\Model\Model;

defined('_WPBOOKINGHOTEL_EXEC') or die;
extract($displayData);

$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$name_format = str_replace(array('[', ']'), '_', $name);
$modelCategories = Model::getInstance('categories');
$list = $modelCategories->getList();

$list_selected = is_array($value) ? $value : array();

?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> field-servicecategory">
        <select name="<?php echo (esc_attr($name)); ?>" <?php echo($multiple ? ' multiple ' : '')  ?>
                class="list-servicecategory">
            <option value=""><?php esc_attr_e('Select category','wpbookinghotel') ?></option>
            <?php foreach ($list as $item) { ?>
                <option <?php echo($item->id == $value ? ' selected ' : ''); ?>
                        value="<?php echo (esc_attr($item->id)); ?>"><?php esc_html_e($item->name,'wpbookinghotel'); ?></option>
            <?php } ?>
        </select>
    </div>
<?php
$doc = Factory::getDocument();
WpBookingHotelHtmlFrontend::load_jquery_library('select2');
$doc->addLessStylesheet('admin/app/layouts/WooBooking/form/field/servicecategory/servicecategory.less');
$doc->addScriptApplySelector('.field-servicecategory','field_servicecategory',array(
    "field_name"=>  $name,
),'admin/app/layouts/WooBooking/form/field/servicecategory/servicecategory.jquery.js');
