<?php
use WpBookingHotel\Factory;
use WpBookingHotel\Html\WpBookingHotelHtmlFrontend;
use WpBookingHotel\Language\Text;
use WpBookingHotel\Mvc\Model\Model;

defined('_WPBOOKINGHOTEL_EXEC') or die;
extract($displayData);

$id_by_name = "element_field_". $name;
$name_format = str_replace(array('[', ']'), '_', $name);
$seasonsModel = Model::getInstance('seasons');
$list_seasons = $seasonsModel->getList_season_public();

$list_selected = is_array($value) ? $value : array();

?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>"
         class="<?php echo (esc_attr($class)); ?> field-seasons-<?php echo (esc_attr($name_format)) ?> field-seasons">
        <select name="<?php echo (esc_attr($name)); ?>" <?php echo ($multiple ? ' multiple ' : ""); ?>
                class="form-control list-seasons">
            <option value=""> <?php esc_html_e('Select seasons','wpbookinghotel') ?></option>
			<?php foreach ($list_seasons as $season) { ?>
                <option <?php echo (in_array($season->id, $list_selected) ? " selected " : "") ?>
                        value="<?php echo (esc_attr($season->id)); ?>"><?php esc_html_e($season->name,'wpbookinghotel'); ?></option>
			<?php } ?>
        </select>
    </div>
<?php
$doc = Factory::getDocument();
WpBookingHotelHtmlFrontend::load_jquery_library('select2');
$doc->addLessStylesheet('admin/app/layouts/WooBooking/form/field/seasons/seasons.less');
$doc->addScriptApplySelector('.field-seasons','field_seasons',array(
    "field_name"=>  $name,
),'admin/app/layouts/WooBooking/form/field/seasons/seasons.jquery.js');
