<?php

use WpBookingHotel\Factory;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Utilities\Utility;
use WpBookingHotel\Language\Text;
use WpBookingHotel\Html\WpBookingHotelHtmlBackend as WpBookingHotelHtmlBackendAlias;
defined('_WPBOOKINGHOTEL_EXEC') or die;
extract($displayData);

WpBookingHotelHtmlBackendAlias::load_jquery_library('select2');
WpBookingHotelHtmlBackendAlias::load_jquery_library('auto_numeric');


$id_by_name = "element_field_". $name;
$data = $displayData['field']->getForm()->getData();
$modelRoomtype = Model::getInstance('roomtype');
$list = $modelRoomtype->getList();
$list_time = [];
$list_room_type_id = [];
if (!is_array($value)) {
	$list_room_type_id[] = $value;
} else {
	$list_room_type_id = $value;
}
$modelHotel  = Model::getInstance('hotel');
$input = Factory::getInput();
$hotel_id = $input->getInt('id', 0);
$hotel = $modelHotel->getItem($hotel_id);
$price_child = isset($hotel->price_child)?$hotel->price_child:array();
$price_adult = isset($hotel->price_adult)?$hotel->price_adult:array();



$tempalte_roomtype = function ($name, $required, $multiple, $list, $room_type_id, $name_price_adult,$price_adult, $name_price_child, $price_child) {

    ob_start();
    ?>
    <div class="wrapper-item-roomtype">
        <div class="block-room-type">
            <select name="<?php echo($name.'[]'); ?>"
                    required="<?php echo (esc_attr($required)) ?>" <?php echo ($multiple ? ' multiple ' : ""); ?>
                    class="list-room-type">
                <option value=""><?php esc_html_e('Select room type','wpbookinghotel') ?></option>
                <?php foreach ($list as $item) { ?>
                    <option <?php echo ($item->id == $room_type_id ? ' selected ' : null) ?>
                        value="<?php echo (esc_attr($item->id)); ?>"><?php esc_html_e($item->name,'wpbookinghotel'); ?></option>
                <?php } ?>
            </select>
        </div>
        <div class="block-price">
            <input type="text" class="price-adult" name="<?php echo($name_price_adult.'[]');?>" value="<?php echo (esc_attr($price_adult));?>" placeholder="<?php esc_attr_e('Adult price','wpbookinghotel');?>">
            <input type="text" class="price-child" name="<?php echo($name_price_child.'[]');?>" value="<?php echo (esc_attr($price_child));?>" placeholder="<?php esc_attr_e('Child price','wpbookinghotel');?>">
        </div>
        <div class="button-action">
            <button type="button" class="btn btn-primary btn-add-roomtype"><i class="far fa-copy"></i></button>
            <button type="button" class="btn btn-danger btn-delete-roomtype"><i class="far fa-trash-alt"></i></button>
        </div>
    </div>
    <?php
    $content = ob_get_clean();
    return $content;
};


?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> field-roomtypewithprice">
        <?php if(count($list_room_type_id) == 0) {
            echo ($tempalte_roomtype($name, $required, $multiple, $list, null, $name_price_adult,null, $name_price_child, null));
        } elseif (count($list_room_type_id) == 1 && trim($list_room_type_id['0']) == '') {
            echo ($tempalte_roomtype($name, $required, $multiple, $list, null, $name_price_adult,null, $name_price_child, null));
        } else {

            foreach ($list_room_type_id as $key => $room_type_id) {
                echo ($tempalte_roomtype($name, $required, $multiple, $list, $room_type_id,$name_price_adult, $price_adult[$key],$name_price_child, $price_child[$key]));
            }
        }

        ?>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin/app/layouts/WooBooking/form/field/roomtypewithprice/roomtypewithprice.less');
$doc->addScriptApplySelector("#$id_by_name",'field_roomtypewithprice',array(
    "values"=>  $value,
    "item_room_type"=>$tempalte_roomtype($name, $required, $multiple, $list, null, $name_price_adult,null, $name_price_child, null),
    "max_room_type"=> 3,
),'admin/app/layouts/WooBooking/form/field/roomtypewithprice/roomtypewithprice.jquery.js');