<?php

use WpBookingHotel\Factory;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Utilities\Utility;
use WpBookingHotel\Language\Text;
use WpBookingHotel\Html\WpBookingHotelHtmlBackend as WpBookingHotelHtmlBackendAlias;
defined('_WPBOOKINGHOTEL_EXEC') or die;
extract($displayData);

WpBookingHotelHtmlBackendAlias::load_jquery_library('select2');


$id_by_name = "element_field_". $name;
$data = $displayData['field']->getForm()->getData();
$modelRoomtypes = Model::getInstance('roomtypes');
$list = $modelRoomtypes->getList();
$list_time = [];
$list_room_type_id = [];
if (!is_array($value)) {
	$list_room_type_id[] = $value;
} else {
	$list_room_type_id = $value;
}
?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> field-roomtype">
        <select name="<?php echo (esc_attr($name)); ?>"
                required="<?php echo (esc_attr($required)) ?>" <?php echo ($multiple ? ' multiple ' : ""); ?>
                class="list-room-type">
            <option value=""><?php esc_html_e('Select room type','wpbookinghotel') ?></option>
			<?php foreach ($list as $item) { ?>
                <option <?php echo (in_array($item->id, $list_room_type_id) ? ' selected ' : null) ?>
                        value="<?php echo (esc_attr($item->id)); ?>"><?php esc_html_e($item->name,'wpbookinghotel'); ?></option>
			<?php } ?>
        </select>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin/app/layouts/WooBooking/form/field/roomtype/roomtype.less');
$doc->addScriptApplySelector('.field-roomtype','field_roomtype',array(
),'admin/app/layouts/WooBooking/form/field/roomtype/roomtype.jquery.js');