"use strict";
(function ($) {
    $.field_phonenumber = function (element, options) {
        var defaults = {
            list_country: [],
            input_name: "",
            field_name_phone_code:"",
            field_name_countrycode:"",
            phonecode:"",
            current_country:'',
            countrycode:'',
        }
        var plugin = this;

        plugin.settings = {}
        var $element = $(element),
            element = element;
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            $element.find('.wrapper-phone-number input.countries').select2({
                formatResult: plugin.format,
                formatSelection: plugin.format,
                templateResult: function (data) {
                    let $result = "";
                    if (typeof data.id !== "undefined") {
                        $result = $(
                            `<div class="row">
                                <div class="col-md-6">${data.text}</div>
                                <div class="col-md-6"> +${data.phonecode}</div>
                            </div>`
                        );
                    }
                    return $result;
                },
                templateSelection: function (data) {
                    if((data.id) ==='') {
                        if(typeof plugin.settings.phonecode === 'object') {
                            return `${plugin.settings.countrycode} (+ ${plugin.settings.phonecode['0']})`;
                        } else {
                            return `${plugin.settings.countrycode} (+ ${plugin.settings.phonecode})`;
                        }

                    } else {
                        let $result = $(
                            `
                            <span>${data.text}</span>
                            <span> (+ ${data.phonecode})</span>
                        `
                        );
                        $element.find(`input[name="${plugin.settings.field_name_phone_code['0']}"]`).val(data.phonecode);
                        $element.find(`input[name="${plugin.settings.field_name_countrycode['0']}"]`).val(data.countrycode);
                        return $result;
                    }

                },
                escapeMarkup: function (m) {
                    return m;
                },
                data: plugin.settings.list_country,
                dropdownCssClass: "phone-number-field",
                placeholder:''
            });
        };
        plugin.format = function (state) {

            if (!state.id) return state.text;
            return `<img class='flag' src=admin/resources/flags/${state.id.toLowerCase()}.png/>${state.text}`;
        }
        plugin.example_function = function () {
        };
        plugin.init();
    }

    $.fn.field_phonenumber = function (options) {

        return this.each(function () {

            if (undefined == $(this).data('field_phonenumber')) {
                var plugin = new $.field_phonenumber(this, options);
                $(this).data('field_phonenumber', plugin);
            }
        });
    }
})(jQuery);

