<?php

use WpBookingHotel\Factory;
use WpBookingHotel\Html\WpBookingHotelHtmlBackend as WpBookingHotelHtmlBackendAlias;
use WpBookingHotel\Language\Text;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Utilities\Utility;
defined('_WPBOOKINGHOTEL_EXEC') or die;
extract($displayData);
WpBookingHotelHtmlBackendAlias::load_jquery_library('select2');


$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$data = $displayData['field']->getForm()->getData();
$list = get_pages();
$list_time = [];
$list_page_id = [];
if (!is_array($value)) {
	$list_page_id[] = $value;
} else {
	$list_page_id = $value;
}



?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> field-pages">
        <select name="<?php echo (esc_attr($name)); ?>" required="<?php echo (esc_attr($required)) ?>" <?php echo ($multiple ? ' multiple ' : ""); ?>
                class="list-page">
            <option value=""><?php esc_html_e('Select page','wpbookinghotel') ?></option>
			<?php foreach ($list as $item) { ?>
                <option <?php echo (in_array($item->ID, $list_page_id) ? ' selected ' : null) ?>
                        value="<?php echo (esc_attr($item->ID)); ?>"><?php esc_html_e($item->post_title,'wpbookinghotel'); ?></option>
			<?php } ?>
        </select>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin/app/layouts/WooBooking/form/field/pages/pages.less');
$doc->addScriptApplySelector("#$id_by_name",'field_pages',array(
),'admin/app/layouts/WooBooking/form/field/pages/pages.jquery.js');