<?php

use WpBookingHotel\Utilities\Utility;
use WpBookingHotel\Html\WpBookingHotelHtmlBackend as WpBookingHotelHtmlBackendAlias;
use WpBookingHotel\Factory;
use WpBookingHotel\Language\Text;

defined('_WPBOOKINGHOTEL_EXEC') or die;
extract($displayData);


WpBookingHotelHtmlBackendAlias::load_jquery_library('select2');

$doc = Factory::getDocument();
$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="field-gender">
        <select class="list-gender" name="<?php echo (esc_attr($name)); ?>">
            <option value=""><?php esc_html_e('Select Gender','wpbookinghotel') ?></option>
            <option <?php echo($value == 'a.ordering ASC' ? ' selected ' : '') ?> value="a.ordering ASC"><?php esc_html_e('Male','wpbookinghotel') ?></option>
            <option <?php echo($value == 'a.ordering DESC' ? ' selected ' : '') ?> value="a.ordering DESC"><?php esc_html_e('Female','wpbookinghotel') ?></option>
        </select>
    </div>
<?php
$doc->addLessStyleSheet('admin/app/layouts/WooBooking/form/field/gender/gender.less');
$doc->addScriptApplySelector('.field-gender', 'field_gender', array(
), 'admin/app/layouts/WooBooking/form/field/gender/jquery.gender.js');
