<?php
defined('_WPBOOKINGHOTEL_EXEC') or die;
use WpBookingHotel\Factory;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Utilities\Utility;
use WpBookingHotel\Html\WpBookingHotelHtmlBackend as WpBookingHotelHtmlBackendAlias;
use WpBookingHotel\Language\Text;
extract($displayData);

WpBookingHotelHtmlBackendAlias::load_jquery_library('select2');


$id_by_name = "element_field_". $name;
$data = $displayData['field']->getForm()->getData();
$db=Factory::getDBO();
$fields=$db->getTableColumns(Utility::getTableName('hotel'));
$list_field_for_content=array();
foreach ($fields as $field=>$type){
    if(strpos($field,"id")===false){
        $list_field_for_content['hotel'][]="{hotel_{$field}}";
    }
}
$fields=$db->getTableColumns(Utility::getTableName('order'));

foreach ($fields as $field=>$type){
    $list_field_for_content['order'][]="{order_{$field}}";
}
$fields=$db->getTableColumns(Utility::getTableName('customer'));

foreach ($fields as $field=>$type){
    if(strpos($field,"id")===false){
        $list_field_for_content['customer'][]="{customer_{$field}}";
    }
}
$fields=$db->getTableColumns(Utility::getTableName('order_detail'));

foreach ($fields as $field=>$type){
    if(strpos($field,"id")===false){
        $list_field_for_content['orderdetail'][]="{orderdetail_{$field}}";
    }
}
$fields=$db->getTableColumns(Utility::getTableName('order_detail_rate'));

foreach ($fields as $field=>$type){
    if(strpos($field,"id")===false){
        $list_field_for_content['orderdetailrate'][]="{orderdetailrate_{$field}}";
    }
}

?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> field-fieldsendsms">
        <div class="row">
            <div class="col-md-3">
                <h4><?php esc_html_e("Hotel",'wpbookinghotel'); ?></h4>
                <ul class="fields">
                    <?php foreach ($list_field_for_content['hotel'] as $field){ ?>
                        <li><?php echo (esc_html($field)) ?></li>
                    <?php } ?>
                </ul>
            </div>
            <div class="col-md-3">
                <div class="block-location-code">
                    <h4><?php esc_html_e("Location",'wpbookinghotel'); ?></h4>
                    <ul class="fields">
                        <li><?php echo (esc_html('{location_i}')); ?></li>
                    </ul>
                </div>
                <div class="block-customer-code">
                    <h4><?php esc_html_e("Customer",'wpbookinghotel'); ?></h4>
                    <ul class="fields">
                        <?php foreach ($list_field_for_content['customer'] as $field){ ?>
                            <li><?php echo (esc_html($field)) ?></li>
                        <?php } ?>
                    </ul>
                </div>
            </div>
            <div class="col-md-3">
                <h4><?php esc_html_e("Order",'wpbookinghotel'); ?></h4>
                <ul class="fields">
                    <?php foreach ($list_field_for_content['order'] as $field){ ?>
                        <li><?php echo (esc_html($field)) ?></li>
                    <?php } ?>
                </ul>
            </div>
            <div class="col-md-3">
                <h4><?php esc_html_e("Order detail",'wpbookinghotel'); ?></h4>
                <ul class="fields">
                    <?php foreach ($list_field_for_content['orderdetail'] as $field){ ?>
                        <li><?php echo (esc_html($field)) ?></li>
                    <?php } ?>
                </ul>
            </div>
        </div>
        <div class="row">
            <div class="col-md-3">
                <h4><?php esc_html_e("Room type",'wpbookinghotel'); ?></h4>
                <ul class="fields">
                    <li><?php echo (esc_html('{room_type_i}')); ?></li>
                </ul>
            </div>
            <div class="col-md-3">
                <h4><?php esc_html_e("Amenities",'wpbookinghotel'); ?></h4>
                <ul class="fields">
                    <li><?php echo (esc_html('{amenities_i}')); ?></li>
                </ul>
            </div>
            <div class="col-md-3">
                <h4><?php esc_html_e("Service",'wpbookinghotel'); ?></h4>
                <ul class="fields">
                    <li><?php echo (esc_html('{service_i}')); ?></li>
                </ul>
            </div>
            <div class="col-md-3">
                <h4><?php esc_html_e("Order detail rate",'wpbookinghotel'); ?></h4>
                <ul class="fields">
                    <?php foreach ($list_field_for_content['orderdetailrate'] as $field){ ?>
                        <li><?php echo (esc_html($field)) ?></li>
                    <?php } ?>
                </ul>
            </div>
        </div>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin/app/layouts/WooBooking/form/field/fieldsendsms/fieldsendsms.less');
$doc->addScriptApplySelector('.field-fieldsendsms','field_fieldsendsms',array(
),'admin/app/layouts/WooBooking/form/field/fieldsendsms/fieldsendsms.jquery.js');