<?php
defined('_WPBOOKINGHOTEL_EXEC') or die;
use WpBookingHotel\Factory;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Utilities\Utility;
use WpBookingHotel\Html\WpBookingHotelHtmlBackend as WpBookingHotelHtmlBackendAlias;
use WpBookingHotel\Language\Text;
extract($displayData);

WpBookingHotelHtmlBackendAlias::load_jquery_library('select2');


$id_by_name = "element_field_". $name;
$data = $displayData['field']->getForm()->getData();
$db=Factory::getDBO();
$fields=$db->getTableColumns(Utility::getTableName('tour'));
$list_field_for_content=array();
foreach ($fields as $field=>$type){
    if(strpos($field,"id")===false){
        $list_field_for_content['tour'][]="{tour_{$field}}";
    }
}
$fields=$db->getTableColumns(Utility::getTableName('order'));

foreach ($fields as $field=>$type){
    $list_field_for_content['order'][]="{order_{$field}}";
}
$fields=$db->getTableColumns(Utility::getTableName('customer'));

foreach ($fields as $field=>$type){
    if(strpos($field,"id")===false){
        $list_field_for_content['customer'][]="{customer_{$field}}";
    }
}
$fields=$db->getTableColumns(Utility::getTableName('order_detail'));

foreach ($fields as $field=>$type){
    if(strpos($field,"id")===false){
        $list_field_for_content['orderdetail'][]="{orderdetail_{$field}}";
    }
}

?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> field-fieldsendemail">
        <div class="row">
            <div class="col-md-3">
                <h4><?php esc_html_e("Tour",'wpbookinghotel'); ?></h4>
                <ul class="fields">
                    <?php foreach ($list_field_for_content['tour'] as $field){ ?>
                        <li><?php echo (esc_html($field)) ?></li>
                    <?php } ?>
                </ul>
            </div>
            <div class="col-md-3">
                <div class="block-location-code">
                    <h4><?php esc_html_e("Location",'wpbookinghotel'); ?></h4>
                    <ul class="fields">
                        <li><?php esc_attr_e('{location_i}','wpbookinghotel') ?></li>
                    </ul>
                </div>
                <div class="block-customer-code">
                    <h4><?php esc_html_e("Customer",'wpbookinghotel'); ?></h4>
                    <ul class="fields">
                        <?php foreach ($list_field_for_content['customer'] as $field){ ?>
                            <li><?php echo (esc_html($field)) ?></li>
                        <?php } ?>
                    </ul>
                </div>
            </div>
            <div class="col-md-3">
                <h4><?php esc_html_e("Order",'wpbookinghotel'); ?></h4>
                <ul class="fields">
                    <?php foreach ($list_field_for_content['order'] as $field){ ?>
                        <li><?php echo (esc_html($field)) ?></li>
                    <?php } ?>
                </ul>
            </div>
            <div class="col-md-3">
                <h4><?php esc_html_e("Order_detail",'wpbookinghotel'); ?></h4>
                <ul class="fields">
                    <?php foreach ($list_field_for_content['orderdetail'] as $field){ ?>
                        <li><?php echo (esc_html($field)) ?></li>
                    <?php } ?>
                </ul>
            </div>
        </div>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin/app/layouts/WooBooking/form/field/fieldsendemail/fieldsendemail.less');
$doc->addScriptApplySelector('.field-fieldsendemail','field_fieldsendemail',array(
),'admin/app/layouts/WooBooking/form/field/fieldsendemail/fieldsendemail.jquery.js');