<?php

use WpBookingHotel\Factory;
use WpBookingHotel\Html\WpBookingHotelHtmlBackend;
use WpBookingHotel\Language\Text;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Utilities\Utility;
defined('_WPBOOKINGHOTEL_EXEC') or die;
extract($displayData);

$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);

?>
    <div id="<?php esc_html_e($id_by_name) ?>" class="<?php esc_html_e($class); ?> element-field-closetime">
        <input type="text" id="close-time" class="form-control close-time" value="<?php esc_html_e($value);?>" />
        <input type="hidden" name="<?php esc_html_e($name);?>" />
    </div>
<?php
$doc = Factory::getDocument();
WpBookingHotelHtmlBackend::load_jquery_library('moment');
WpBookingHotelHtmlBackend::load_jquery_library('daterangepicker');
$doc->addLessStyleSheet('admin/app/layouts/WooBooking/form/field/closetime/closetime.less');
$doc->addScriptApplySelector('.element-field-closetime','field_closetime',array(
    'input_name'=>$name,
    'value'=>$value
),'admin/app/layouts/WooBooking/form/field/closetime/closetime.jquery.js');
