<?php
use WpBookingHotel\Factory;
use WpBookingHotel\Html\WpBookingHotelHtmlFrontend;
use WpBookingHotel\Mvc\Model\Model;

defined('_WPBOOKINGHOTEL_EXEC') or die;
extract($displayData);


$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$name_format = str_replace(array('[', ']'), '_', $name);

?>
    <div id="<?php echo (esc_html($id_by_name)) ?>"
         class="<?php echo (esc_html($class)); ?> field-buffer-time hide-option">
        <select class="time-buffer" name="<?php echo (esc_attr($name)); ?>">
            <?php for ($i = 0; $i <= 23; $i++) { ?>
                <?php if ($i !== 0) { ?>
                    <option <?php echo($value == $i ? ' selected ' : '') ?>
                            value="<?php esc_html_e($i); ?>"><?php printf("%sh", $i) ?></option>
                    <option <?php echo($value == ($i + 0.5) ? ' selected ' : '') ?>
                            value="<?php echo($i + 0.5) ?>"><?php printf("%sh 30min", $i) ?></option>
                <?php } else { ?>
                    <option <?php echo($value == $i ? ' selected ' : '') ?>
                            value="<?php esc_html_e($i); ?>"><?php esc_attr_e('30min','wpbookinghotel') ?></option>
                <?php } ?>
            <?php } ?>
        </select>
    </div>
<?php
$doc = Factory::getDocument();
WpBookingHotelHtmlFrontend::load_jquery_library('select2');
$doc->addLessStylesheet('admin/app/layouts/WooBooking/form/field/buffertime/buffertime.less');
$doc->addScriptApplySelector('#'.$id_by_name,'field_buffertime',array(
    "field_name"=>  $name,
),'admin/app/layouts/WooBooking/form/field/buffertime/buffertime.jquery.js');
