<?php
use WpBookingHotel\Factory;
use WpBookingHotel\Html\WpBookingHotelHtmlFrontend;
use WpBookingHotel\Mvc\Model\Model;

defined('_WPBOOKINGHOTEL_EXEC') or die;
extract($displayData);


$id_by_name = "element_field_". $name;
$name_format = str_replace(array('[', ']'), '_', $name);
$activitiesModel = Model::getInstance('activities');
$list_location = $activitiesModel->getList_activity_public();
$list_selected = is_array($value) ? $value : array();


?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>"
         class="<?php echo (esc_attr($class)); ?> field-activities-<?php echo (esc_attr($name_format)) ?> field-activities">
        <select name="<?php echo (esc_attr($name)); ?>" <?php echo ($multiple ? ' multiple ' : ""); ?>
                class="form-control list-activities">
            <option value=""> <?php esc_attr_e('Select activities','wpbookinghotel') ?></option>
			<?php foreach ($list_location as $activity) { ?>
                <option <?php echo (in_array($activity->id, $list_selected) ? " selected " : "") ?>
                        value="<?php echo (esc_attr($activity->id)); ?>"><?php esc_html_e($activity->name,'wpbookinghotel'); ?></option>
			<?php } ?>
        </select>
    </div>
<?php
$doc = Factory::getDocument();
WpBookingHotelHtmlFrontend::load_jquery_library('select2');
$doc->addLessStylesheet('admin/app/layouts/WooBooking/form/field/activities/activities.less');
$doc->addScriptApplySelector('.field-activities','field_activities',array(
    "field_name"=>  $name,
),'admin/app/layouts/WooBooking/form/field/activities/activities.jquery.js');
