<?php
if ( ! class_exists( 'Netbase_Element_Widgets_Author_Blog' ) ):

    add_action( 'widgets_init', 'NB_Load_Author_Blog_Widget' );

    function NB_Load_Author_Blog_Widget() {
        register_widget( 'Netbase_Element_Widgets_Author_Blog' );
    }
class Netbase_Element_Widgets_Author_Blog extends WP_Widget {

	function __construct() {
        parent::__construct(
            'nbelement_author_blog',
            esc_html__('NB - Author Blog', 'hotelier-elements'),
            array( 'description' => esc_html__( 'Show author blog info', 'hotelier-elements' ), )
        );
    }
    /**
     * How to display the widget on the screen.
     */
    function widget($args, $instance) {
        extract($args);       
        $html = '';
        $title     = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );    
        $author_img =  get_avatar( get_the_author_meta( 'ID' ) , '512' );
		$author_desc = get_the_author_meta('user_description');
        
        echo $args['before_widget'];

        $html='<div class="author_blog">';
        $html.= $args['before_title'] . esc_attr($title) . $args['after_title'];
        $html.='<div class="thumbnail">';
        $html.= $author_img;
        $html.= '<div class="author_description">'.esc_attr($author_desc).'</div>';
        $html.='</div>';
        $html.='</div>';
        echo $html;

        echo $args['after_widget'];
    }

    /**
     * Update the widget settings.
     */
    function update($new_instance, $old_instance) {
        $instance = $old_instance;

        $instance['title'] = strip_tags($new_instance['title']);
        /* Strip tags to remove HTML (important for text inputs). */
        
        return $instance;
    }

    /**
     * Displays the widget settings controls on the widget panel.
     * Make use of the get_field_id() and get_field_name() function
     * when creating your form elements. This handles the confusing stuff.
     */
    function form($instance) {
        
        
        ?>
    
        <p>
        <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:', 'hotelier-elements'); ?></label>
        <input type="text" class="widefat" id="<?php echo $this->get_field_id('title'); ?>"
               name="<?php echo $this->get_field_name('title'); ?>" value="<?php if(isset($instance['title'])){echo $instance['title'];} ?>"/>
        </p>
    <?php
    }
}
endif;
?>