<?php
/*
Plugin Name: Hotelier Elements
Plugin URI: http://netbaseteam.com/
Description: Prodive all Elementor elements and widgets.
Version: 1.0.0
Author: NBTeam
Author URI: http://themeforest.net/user/netbaseteam
*/

define('TP_ELEMENTS_PATH', plugin_dir_path(__FILE__));
define('TP_ELEMENTS_NAME', plugin_basename(__FILE__));
define('TP_ELEMENTS_URL', plugin_dir_url( __FILE__ ));

class Netbase_Elements
{
    public static function init()
    {
        self::include_function_plugins();
        self::load_widget();
        add_action('wp_enqueue_scripts', array(__CLASS__, 'hotelier_elements_enqueue_scripts'),9999);
        add_action( 'elementor/widgets/widgets_registered', [ __CLASS__, 'hotelier_register_widgets' ] );
        add_action( 'elementor/elements/categories_registered', [ __CLASS__, 'hotelier_add_elementor_widget_categories' ] );
        add_shortcode( 'hotelier-search-form', [__CLASS__,'hotelier_search_form'] );
        add_shortcode('hotelier-top-left-content', [__CLASS__,'hotelier_header_top_left_content'] );
        add_shortcode('hotelier-top-right-content', [__CLASS__,'hotelier_header_top_right_content'] );
        add_shortcode('hotelier-singup-register', [__CLASS__,'hotelier_singup_register'] );
    }

    public static function hotelier_elements_enqueue_scripts() {

        wp_enqueue_style( 'swiper', TP_ELEMENTS_URL . 'assets/vendors/swiper/swiper.min.css', array(), '4.5.0');
        wp_enqueue_script( 'swiper',  TP_ELEMENTS_URL . 'assets/vendors/swiper/swiper.min.js', array('jquery'), '4.5.0', true);
        
        wp_enqueue_style( 'hotelier_elements', TP_ELEMENTS_URL . 'assets/css/main.css', array(), '20180324' );
        if(is_rtl()){
            wp_enqueue_style( 'hotelier_elements_rtl', TP_ELEMENTS_URL . 'assets/rtl.css', array(), '20180324' ); 
        }
        wp_enqueue_script( 'hotelier_elements', TP_ELEMENTS_URL . 'assets/js/main.js', array( 'jquery' ), '20180324', true );
        wp_localize_script('hotelier_elements','hotelier_elements',array(
            'siteUrl' => site_url(),
        ));

        wp_enqueue_script( 'equal_height', TP_ELEMENTS_URL . 'assets/vendors/jquery-match-height/jquery.matchHeight-min.js', array(), '0.7.2', true );
        wp_enqueue_script( 'imageload', TP_ELEMENTS_URL . 'assets/vendors/imagesloaded/imagesloaded.pkgd.min.js', array(), '4.1.4', true );
        wp_enqueue_script( 'isotope', TP_ELEMENTS_URL . 'assets/vendors/isotope/isotope.pkgd.min.js', array(), '3.0.6', true );

        wp_enqueue_style( 'magnific-popup', TP_ELEMENTS_URL . 'assets/vendors/magnific-popup/magnific-popup.css', array(), '1.1.0' );
        wp_enqueue_script( 'magnific-popup', TP_ELEMENTS_URL . 'assets/vendors/magnific-popup/jquery-magnific-popup.min.js', array('jquery'), '1.1.0', true );

    }
    
    public static function include_function_plugins() {

        if ( ! function_exists( 'is_plugin_active' ) ) {
            require_once( ABSPATH . 'wp-admin/includes/plugin.php' );
        }
    }

    public static function load_widget() {
        require_once( TP_ELEMENTS_PATH . 'widgets/social-links.php' );
        require_once( TP_ELEMENTS_PATH . 'widgets/contact-info.php' );
        require_once( TP_ELEMENTS_PATH . 'widgets/recent-blog.php' );
    }

    public static function hotelier_register_widgets() {
        self::include_widgets_files();
    }

    public static function include_widgets_files() {
        require_once( TP_ELEMENTS_PATH . 'elementor_widgets/blog/blog.php' );
        require_once( TP_ELEMENTS_PATH . 'elementor_widgets/testimonials/testimonials.php' );
        require_once( TP_ELEMENTS_PATH . 'elementor_widgets/tour-suggest/tour-suggest.php' );
        require_once( TP_ELEMENTS_PATH . 'elementor_widgets/icon-box-custom/icon-box-custom.php' );
        require_once( TP_ELEMENTS_PATH . 'elementor_widgets/slider-animation/slider-animation.php' );
    }

    public static function hotelier_add_elementor_widget_categories( $elements_manager ) {

        $elements_manager->add_category(
            'hotelier-elements',
            [
                'title' => __( 'Hotelier', 'hotelier-elements' ),
                'icon'  => 'fa fa-plug',
            ]
        );
    }

    //https://codecanyon.net/thema/js/test.js
    //thema/js/test.js
    //
    public function addScriptApplySelectorForTheme($selector="",$function_name,$config,$js_path){
        $root_url_theme="https://codecanyon.net/thema";
        $doc->addScriptApplySelector($selector,$function_name,$config,$root_url_theme."/".$js_path);
    }    

    public static function hotelier_search_form() {
        ob_start();
        echo '<div class="search-form-header">';
        echo get_search_form();
        echo '</div>';
        return ob_get_clean();
    }

    public static function hotelier_header_top_right_content($atts = array(), $content = '') {
        $atts = shortcode_atts(array(
            'phone' => __('+1 808 111 9999','hotelier-elements'),
            'login' => __('Sign in','hotelier-elements'),
            'facebook' => '#',
            'twitter' => '#',
            'linkedin' => '#',
            'instagram' => '#',
            'icon-search' => 'yes',
            'icon-cart' => 'yes',
        ), $atts);

        ob_start();

        ?>

        <div class="header-top-right">
            <div class="header-top-right__social">
                <ul>
                    <?php if (!empty($atts['facebook'])): ?>
                        <li>
                            <a href="<?php echo esc_attr( $atts['facebook'] ); ?>">
                                <span class="icon-fa-facebook-f"></span>
                            </a>
                        </li>
                    <?php endif ?>
                    <?php if (!empty($atts['twitter'])): ?>
                        <li>
                            <a href="<?php echo esc_attr( $atts['twitter'] ); ?>">
                                <span class="icon-fa-twitter"></span>
                            </a>
                        </li>
                    <?php endif ?>
                    <?php if (!empty($atts['linkedin'])): ?>
                        <li>
                            <a href="<?php echo esc_attr( $atts['linkedin'] ); ?>">
                                <span class="icon-fa-linkedin-in"></span>
                            </a>
                        </li>
                    <?php endif ?>
                    <?php if (!empty($atts['instagram'])): ?>
                        <li>
                            <a href="<?php echo esc_attr( $atts['instagram'] ); ?>">
                                <span class="icon-fa-instagram"></span>
                            </a>
                        </li>
                    <?php endif ?>
                </ul>
            </div>
            <?php if( $atts['icon-search'] == 'yes' ) { ?>
                <div class="header-top-right__search">
                    <ul>
                        <li class="icon-search">
                            <a href="#">
                                <span><?php _e('Icon Search','hotelier-elements') ?></span>
                            </a>
                            <?php echo do_shortcode( '[hotelier-search-form]' ); ?>
                        </li>
                    </ul>
                </div>
            <?php } ?>
            <?php if( $atts['icon-cart'] == 'yes' ) { ?>
                <div class="header-top-right__cart">
                    <ul>
                        <li class="icon-shopping-cart">
                            <a href="#">
                                <span><?php _e('Icon cart','hotelier-elements') ?></span>
                            </a>
                        </li>
                    </ul>
                </div>
            <?php } ?>
            <?php if( $atts['phone'] != '' ) { ?>
                <div class="header-top-right__phone">
                    <span class="icon-phone"></span>
                    <span><a href="#"><?php echo esc_attr( $atts['phone'] ) ?></a></span>
                </div>
            <?php } ?>
            <div class="header-top-right__singin">
                <span>
                    <?php if (is_user_logged_in()) { ?>
                        <a class="login_button" href="<?= site_url() . '/sellercenter/wb_dashboard' ?>"><?= esc_attr__('Dashboard','hotelier-elements') ?></a>
                    <?php } else { ?>
                        <a class="login_button" id="show_login" href="javascript"><?= esc_attr__('Sign in','hotelier-elements') ?></a>
                    <?php } ?>
                </span>
            </div>            
        </div>
    <?php

        return ob_get_clean();
    }

    // shortcode right content heart top
    public static function hotelier_header_top_left_content($atts = array(), $content = '')
    {      
        ob_start();  
        ?>

        <div class="header-top-left">            
            <div class="header-top-left__usd">
                <div class="select usd">
                    <div class="select-usd">
                        <span><?php echo esc_attr__('USD','hotelier-elements') ?></span>
                        <div class="usd-wrap" id="usd">
                            <ul>
                                <li><a href="#"><?php echo esc_attr__('USD','hotelier-elements') ?></a></li>
                                <li><a href="#"><?php echo esc_attr__('EURO','hotelier-elements') ?></a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            <div class="header-top-left__language">
                <div class="select eng">
                    <div class="select-language">
                        <span><?php echo esc_attr__('ENG','hotelier-elements') ?></span>
                        <div class="language-wrap" id="language">
                            <ul>
                                <li><a href="#"><?php echo esc_attr__('ENG','hotelier-elements') ?></a></li>
                                <li><a href="#"><?php echo esc_attr__('VIE','hotelier-elements') ?></a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            <div class="header-top-left__km">
                <span><?php echo esc_attr__('KM','hotelier-elements') ?></span>
                <input type="checkbox" id="switch" /><label for="switch"><?php echo esc_attr__('Toggle','hotelier-elements') ?></label><span><?php echo esc_attr__('MILE','hotelier-elements') ?></span>
            </div>
        </div>
    <?php

        return ob_get_clean();
    }

    public static function hotelier_singup_register($atts = array(), $content = '') {

        $atts = shortcode_atts(array(
            'text' => __('Get the Best Deals for you in Summer Holidays 20% OFF','hotelier-elements'),
            'btn' => __('Get Code','hotelier-elements'),
        ), $atts);
        
        ob_start(); ?>

        <div class="hotelier-singup-register">
            <div id="login-register-password">
                <a href="javascript:;" class="close">
                    <span class="icon-close"></span>
                </a>
                <?php global $user_ID, $user_identity; if (!$user_ID) { ?>
                    <div class="tab_container_login">
                        <div id="tab1_login" class="tab_content_login">
                            <div class="title"><?php esc_attr_e( 'Login Account', 'hotelier-elements' );  ?></div>
                            <?php do_action( 'nb_before_form_login' ); ?>
                            <form method="post" action="<?php bloginfo('url') ?>/wp-login.php" class="wp-user-form">
                                <div class="username form-group">
                                    <input class="form-control" type="text" name="log" value="" size="20"  tabindex="11" placeholder="<?php _e('Email Address*','hotelier-elements') ?>" />
                                    <span class="icon-mail"></span>
                                </div>
                                <div class="password form-group">
                                    <input class="form-control" type="password" name="pwd" value="" size="20" id="user_pass" tabindex="12" placeholder="<?php _e('Password*','hotelier-elements') ?>" />
                                    <span class="icon-padlock"></span>
                                </div>
                                <div class="login_fields">
                                    <div class="rememberme">
                                        <label for="rememberme">
                                            <input type="checkbox" name="rememberme" value="forever" checked="checked" id="rememberme" tabindex="13" /> <?php esc_attr_e( 'Remember me', 'hotelier-elements' );  ?>
                                        </label>
                                        <a class="lost" href="#tab3_login"><?php esc_attr_e( 'Forgot Password', 'hotelier-elements' );  ?></a>
                                    </div>
                                    <?php do_action('login_form'); ?>

                                    <input type="submit" name="user-submit" value="<?php _e('Login'); ?>" tabindex="14" class="user-submit" />
                                    <input type="hidden" name="redirect_to" value="<?php echo esc_url( site_url() . '/sellercenter/wb_dashboard/' ) ?>" />
                                    <input type="hidden" name="user-cookie" value="1" />
                                    <div class="has-account">
                                        <span><?php esc_attr_e( 'Don’t have an account ?', 'hotelier-elements' );  ?></span>
                                        <a href="#tab2_login"><?php esc_attr_e( 'Sign up', 'hotelier-elements' );  ?></a>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div id="tab2_login" class="tab_content_login" style="display:none;">
                            <div class="title"><?php esc_attr_e( 'Sign up', 'hotelier-elements' ); ?></div>
                            <form method="post" action="<?php echo site_url('wp-login.php?action=register', 'login_post') ?>" class="wp-user-form">
                                <div class="username form-group">
                                    <input class="form-control" placeholder="<?php _e('User Name*','hotelier-elements') ?>" type="text" name="user_login" value="" size="20"  tabindex="101" />
                                    <span class="icon-user-thin"></span>
                                </div>
                                <div class="password form-group">
                                    <input class="form-control" placeholder="<?php _e('Email Address*','hotelier-elements') ?>" type="text" name="user_email" value="" size="25" id="user_email" tabindex="102" />
                                    <span class="icon-mail"></span>
                                </div>
                                <div class="login_fields">
                                    <?php do_action('register_form'); ?>
                                    <input type="submit" name="user-submit" value="<?php _e('CREATE ACCOUNT'); ?>" class="user-submit" tabindex="103" />
                                    <input type="hidden" name="redirect_to" value="<?php echo $_SERVER['REQUEST_URI']; ?>?register=true" />
                                    <input type="hidden" name="user-cookie" value="1" />
                                    <div class="has-account">
                                        <span><?php esc_attr_e( 'Already have an account?', 'hotelier-elements' ); ?></span>
                                        <a href="#tab1_login"><?php esc_attr_e( 'Login', 'hotelier-elements' ); ?></a>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div id="tab3_login" class="tab_content_login" style="display:none;">
                            <div class="title"><?php esc_attr_e( 'Forgot Password', 'hotelier-elements' ); ?></div>
                            <form method="post" action="<?php echo site_url('wp-login.php?action=lostpassword', 'login_post') ?>" class="wp-user-form">
                                <div class="username form-group">
                                    <input class="form-control" placeholder="<?php _e('Email Address*','hotelier-elements') ?>" type="text" name="user_login" value="" size="20"  tabindex="1001" />
                                    <span class="icon-mail"></span>
                                </div>
                                <div class="login_fields">
                                    <?php do_action('login_form', 'resetpass'); ?>
                                    <input type="submit" name="user-submit" value="<?php _e('Send'); ?>" class="user-submit" tabindex="1002" />
                                    <input type="hidden" name="redirect_to" value="<?php echo $_SERVER['REQUEST_URI']; ?>?reset=true" />
                                    <input type="hidden" name="user-cookie" value="1" />
                                    <div class="has-account">
                                        <span><?php esc_attr_e( 'Already have an account?', 'hotelier-elements' ); ?></span>
                                        <a href="#tab1_login"><?php esc_attr_e( 'Login', 'hotelier-elements' ); ?></a>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                <?php } else { // is logged in ?>
                <div class="sidebox">
                    <h3><?php esc_attr_e( 'Welcome', 'hotelier-elements' ); ?>, <?php echo $user_identity; ?></h3>
                    <div class="usericon">
                        <?php global $userdata; echo get_avatar($userdata->ID, 60); ?>
                    </div>
                    <div class="userinfo">
                        <p><?php esc_attr_e( 'You are logged in as', 'hotelier-elements' ); ?> <strong><?php echo $user_identity; ?></strong></p>
                        <p>
                            <a href="<?php echo wp_logout_url('index.php'); ?>"><?php esc_attr_e( 'Log out', 'hotelier-elements' ); ?></a> |
                            <?php if (current_user_can('manage_options')) {
                            echo '<a href="' . admin_url() . '">' . __('Admin','hotelier-elements') . '</a>'; } else {
                            echo '<a href="' . admin_url() . 'profile.php">' . __('Profile','hotelier-elements') . '</a>'; } ?>
                        </p>
                    </div>
                </div>
                <?php } ?>
            </div>
        </div>

        <?php return ob_get_clean();
    }
}
Netbase_Elements::init();
