<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class NB_Tour_Suggest extends Widget_Base {

	public function get_name() {
		return 'nb-tour-suggest';
	}

	public function get_title() {
		return __( 'Tour Suggest', 'hotelier-elements' );
	}

	public function get_icon() {
		return 'eicon-slider-album';
	}

	public function get_categories() {
		return [ 'hotelier-elements' ];
	}

	public function get_script_depends() {
		return [ 'hotelier-elements' ];
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'Content', 'hotelier-elements' ),
			]
        );
        
        $this->add_control(
			'description',
			[
				'label' => __( 'Description', 'hotelier-elements' ),
				'type' => Controls_Manager::TEXT,
			]
        );
        
        $this->add_control(
			'title',
			[
				'label' => __( 'Title', 'hotelier-elements' ),
				'type' => Controls_Manager::TEXT,
			]
        );
        
        $this->add_control(
			'content',
			[
				'label' => __( 'Content', 'hotelier-elements' ),
				'type' => Controls_Manager::TEXTAREA,
				'rows' => 10
			]
		);

		$this->add_control(
			'text_link',
			[
				'label' => __( 'Text Link', 'hotelier-elements' ),
				'type' => Controls_Manager::TEXT,
			]
		);

		$this->add_control(
			'link',
			[
				'label' => __( 'Link', 'hotelier-elements' ),
				'type' => Controls_Manager::TEXT,
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'image',
			[
				'label' => __( 'Image', 'hotelier-elements' ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'tour_list',
			[
				'label' => __( 'Tour List', 'hotelier-elements' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
			]
		);

		$this->add_control(
			'show_pagination',
			[
				'label' => __( 'Show Pagination', 'hotelier-elements' ),
				'type' => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_navigation',
			[
				'label' => __( 'Show Navigation', 'hotelier-elements' ),
				'type' => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->end_controls_section();

	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

		$template_path = TP_ELEMENTS_PATH . '/elementor_widgets/tour-suggest/template.php';

		require $template_path;
	}

	/**
	 * Render the widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function _content_template() {
		?>
		<div class="title">
			{{{ settings.title }}}
		</div>
		<?php
	}
}

\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new NB_Tour_Suggest() );