<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Icons_Manager;
use Elementor\Core\Schemes;
use Elementor\Repeater;
use Elementor\Utils;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

class NB_Widget_Slider_Animation_Swiper extends Widget_Base
{

    public function get_name()
    {
        return 'nb-slider-animation';
    }

    public function get_categories()
    {
        return ['hotelier-elements'];
    }

    public function get_title()
    {
        return __('Slider Animation', 'hotelier-elements');
    }

    public function get_icon()
    {
        return 'eicon-slider-full-screen';
    }

    public function get_keywords()
    {
        return ['image', 'photo', 'visual', 'box'];
    }

    protected function _register_controls()
    {
        $this->start_controls_section(
            'section_slider_animation',
            [
                'label' => __('Slider Animation', 'hotelier-elements'),
            ]
        );

        $repeater = new Repeater();
        $repeater->add_control(
            'style_heading',
            [
                'label' => __( 'Style Heading', 'hotelier-elements'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $repeater->add_control(
            'vertical',
            [
                'label' => __('Vertical', 'hotelier-elements'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'top' => __('Top', 'hotelier-elements'),
                    'middle' => __('Middle', 'hotelier-elements'),
                    'bottom' => __('Bottom', 'hotelier-elements'),
                ],
                'default' => 'middle',
                'frontend_available' => true,
            ]
        );

        $repeater->add_responsive_control(
            'text_align',
            [
                'label' => __( 'Alignment', 'hotelier-elements' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left'    => [
                        'title' => __( 'Left', 'hotelier-elements' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', 'hotelier-elements' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __( 'Right', 'hotelier-elements' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'left',
            ]
        );

        $repeater->add_control(
            'horizontal',
            [
                'label' => __('Horizontal', 'hotelier-elements'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'left' => __('Left', 'hotelier-elements'),
                    'center' => __('Center', 'hotelier-elements'),
                    'right' => __('Right', 'hotelier-elements'),
                ],
                'default' => 'left',
                'frontend_available' => true,
            ]
        );

        $repeater->add_responsive_control(
            'max_width',
            [
                'label' => __( 'Max Width Content', 'hotelier-elements'),
                'type' => Controls_Manager::SLIDER,
            ]
        );

        $repeater->add_control(
            'heading_heading',
            [
                'label' => __( 'Heading', 'hotelier-elements'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $repeater->add_control(
            'heading',
            [
                'label' => __('Heading', 'hotelier-elements'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'placeholder' => __('Heading', 'hotelier-elements'),
                'default' => __('Bootstrap touch slider', 'hotelier-elements'),
                'dynamic' => [
                    'active' => false,
                ],
            ]
        );

        $repeater->add_responsive_control(
            'animation_heading',
            [
                'label' => __( 'Heading Animation', 'hotelier-elements'),
                'type' => Controls_Manager::SELECT,
                'default' => 'fadeInUp',
                'options' => [
                    '' => __( 'None', 'hotelier-elements'),
                    'fadeInDown' => __( 'Down', 'hotelier-elements'),
                    'fadeInUp' => __( 'Up', 'hotelier-elements'),
                    'fadeInRight' => __( 'Right', 'hotelier-elements'),
                    'fadeInLeft' => __( 'Left', 'hotelier-elements'),
                    'zoomIn' => __( 'Zoom', 'hotelier-elements'),
                ],
            ]
        );

        $repeater->add_control(
            'animation_duration_heading',
            [
                'label' => __( 'Animation Duration', 'hotelier-elements'),
                'type' => Controls_Manager::SELECT,
                'default' => '',
                'options' => [
                    'slow' => __( 'Slow', 'hotelier-elements'),
                    '' => __( 'Normal', 'hotelier-elements'),
                    'fast' => __( 'Fast', 'hotelier-elements'),
                ],
                'prefix_class' => 'animated-',
                'condition' => [
                    'animation_heading!' => '',
                ],
            ]
        );

        $repeater->add_control(
            'animation_delay_heading',
            [
                'label' => __( 'Animation Delay', 'hotelier-elements' ) . ' (ms)',
                'type' => Controls_Manager::NUMBER,
                'default' => '',
                'min' => 0,
                'step' => 100,
                'condition' => [
                    'animation_heading!' => '',
                ],
                'render_type' => 'none',
                'frontend_available' => true,
            ]
        );
        $repeater->add_control(
            'desctiption_heading',
            [
                'label' => __( 'Description', 'hotelier-elements'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $repeater->add_control(
            'description',
            [
                'label' => __('Description', 'hotelier-elements'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'placeholder' => __('Description', 'hotelier-elements'),
                'default' => __('Make Bootstrap Better together.', 'hotelier-elements'),
                'dynamic' => [
                    'active' => false,
                ],
            ]
        );

        $repeater->add_responsive_control(
            'animation_description',
            [
                'label' => __( 'Description Animation', 'hotelier-elements'),
                'type' => Controls_Manager::SELECT,
                'default' => 'fadeInUp',
                'options' => [
                    '' => __( 'None', 'hotelier-elements'),
                    'fadeInDown' => __( 'Down', 'hotelier-elements'),
                    'fadeInUp' => __( 'Up', 'hotelier-elements'),
                    'fadeInRight' => __( 'Right', 'hotelier-elements'),
                    'fadeInLeft' => __( 'Left', 'hotelier-elements'),
                    'zoomIn' => __( 'Zoom', 'hotelier-elements'),
                ],
            ]
        );

        $repeater->add_control(
            'animation_duration_description',
            [
                'label' => __( 'Animation Duration', 'hotelier-elements'),
                'type' => Controls_Manager::SELECT,
                'default' => '',
                'options' => [
                    'slow' => __( 'Slow', 'hotelier-elements'),
                    '' => __( 'Normal', 'hotelier-elements'),
                    'fast' => __( 'Fast', 'hotelier-elements'),
                ],
                'prefix_class' => 'animated-',
                'condition' => [
                    'animation_description!' => '',
                ],
            ]
        );

        $repeater->add_control(
            'animation_delay_description',
            [
                'label' => __( 'Animation Delay', 'hotelier-elements' ) . ' (ms)',
                'type' => Controls_Manager::NUMBER,
                'default' => '',
                'min' => 0,
                'step' => 100,
                'condition' => [
                    'animation_description!' => '',
                ],
                'render_type' => 'none',
                'frontend_available' => true,
            ]
        );
        $repeater->add_control(
            'button-1',
            [
                'label' => __( 'Button 1', 'hotelier-elements'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $repeater->add_control(
            'button_text_1',
            [
                'label' => __( 'Text', 'hotelier-elements' ),
                'type' => Controls_Manager::TEXT,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => __( '', 'hotelier-elements' ),
                'placeholder' => __( '', 'hotelier-elements' ),
            ]
        );

        $repeater->add_control(
            'button_link_1',
            [
                'label' => __( 'Link', 'hotelier-elements' ),
                'type' => Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => __( 'https://your-link.com', 'hotelier-elements' ),
                'default' => [
                    'url' => '#',
                ],
                'condition' => [
                    'button_text_1!' => '',
                ],
            ]
        );

        $repeater->add_responsive_control(
            'button_align_1',
            [
                'label' => __( 'Alignment', 'hotelier-elements' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left'    => [
                        'title' => __( 'Left', 'hotelier-elements' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', 'hotelier-elements' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __( 'Right', 'hotelier-elements' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                    'justify' => [
                        'title' => __( 'Justified', 'hotelier-elements' ),
                        'icon' => 'eicon-text-align-justify',
                    ],
                ],
                'prefix_class' => 'elementor%s-align-',
                'default' => '',
                'condition' => [
                    'button_text_1!' => '',
                ],
            ]
        );

        $repeater->add_control(
            'button_icon_1',
            [
                'label' => __( 'Icon', 'hotelier-elements' ),
                'type' => Controls_Manager::SELECT2,
                'multiple' => '',
                'default' => 'none',
                'options' => [
                    "none" => __('None','hotelier-elements'),
                    "angle-double-down" => __('angle-double-down','hotelier-elements'),
                    "angle-double-left" => __('angle-double-left','hotelier-elements'),
                    "angle-double-right" => __('angle-double-right','hotelier-elements'),
                    "angle-double-up" => __('angle-double-up','hotelier-elements'),
                    "angle-down" => __('angle-down','hotelier-elements'),
                    "angle-left" => __('angle-left','hotelier-elements'),
                    "angle-right" => __('angle-right','hotelier-elements'),
                    "angle-up" => __('angle-up','hotelier-elements'),
                    "arrow-alt-circle-down" => __('arrow-alt-circle-down','hotelier-elements'),
                    "arrow-alt-circle-left" => __('arrow-alt-circle-left','hotelier-elements'),
                    "arrow-alt-circle-right" => __('arrow-alt-circle-right','hotelier-elements'),
                    "arrow-alt-circle-up" => __('arrow-alt-circle-up','hotelier-elements'),
                    "arrow-circle-down" => __('arrow-circle-down','hotelier-elements'),
                    "arrow-circle-left" => __('arrow-circle-left','hotelier-elements'),
                    "arrow-circle-right" => __('arrow-circle-right','hotelier-elements'),
                    "arrow-circle-up" => __('arrow-circle-up','hotelier-elements'),
                    "arrow-down" => __('arrow-down','hotelier-elements'),
                    "arrow-left" => __('arrow-left','hotelier-elements'),
                    "arrow-right" => __('arrow-right','hotelier-elements'),
                    "arrow-up" => __('arrow-up','hotelier-elements'),
                    "arrows-alt" => __('arrows-alt','hotelier-elements'),
                    "arrows-alt-h" => __('arrows-alt-h','hotelier-elements'),
                    "arrows-alt-v" => __('arrows-alt-v','hotelier-elements'),
                    "caret-down" => __('caret-down','hotelier-elements'),
                    "caret-left" => __('caret-left','hotelier-elements'),
                    "caret-right" => __('caret-right','hotelier-elements'),
                    "caret-square-down" => __('caret-square-down','hotelier-elements'),
                    "caret-square-left" => __('caret-square-left','hotelier-elements'),
                    "caret-square-right" => __('caret-square-right','hotelier-elements'),
                    "caret-square-up" => __('caret-square-up','hotelier-elements'),
                    "caret-up" => __('caret-up','hotelier-elements'),
                    "chevron-circle-down" => __('chevron-circle-down','hotelier-elements'),
                    "chevron-circle-left" => __('chevron-circle-left','hotelier-elements'),
                    "chevron-circle-right" => __('chevron-circle-right','hotelier-elements'),
                    "chevron-circle-up" => __('chevron-circle-up','hotelier-elements'),
                    "chevron-down" => __('chevron-down','hotelier-elements'),
                    "chevron-left" => __('chevron-left','hotelier-elements'),
                    "chevron-right" => __('chevron-right','hotelier-elements'),
                    "chevron-up" => __('chevron-up','hotelier-elements'),
                    "long-arrow-alt-down" => __('long-arrow-alt-down','hotelier-elements'),
                    "long-arrow-alt-left" => __('long-arrow-alt-left','hotelier-elements'),
                    "long-arrow-alt-right" => __('long-arrow-alt-right','hotelier-elements'),
                    "long-arrow-alt-up" => __('long-arrow-alt-up','hotelier-elements'),
                    "minus" => __('minus','hotelier-elements'),
                    "minus-circle" => __('minus-circle','hotelier-elements'),
                    "minus-square" => __('minus-square','hotelier-elements'),
                    "plus" => __('plus','hotelier-elements'),
                    "plus-circle" => __('plus-circle','hotelier-elements'),
                    "plus-square" => __('plus-square','hotelier-elements'),
                ],
                'condition' => [
                    'button_text_1!' => '',
                ],
            ]
        );

        $repeater->add_control(
            'button_icon_align_1',
            [
                'label' => __( 'Icon Position', 'hotelier-elements' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'left',
                'options' => [
                    'left' => __( 'Before', 'hotelier-elements' ),
                    'right' => __( 'After', 'hotelier-elements' ),
                ],
                'condition' => [
                    'button_icon_1[value]!' => '',
                ],
            ]
        );

        $repeater->add_control(
            'button_icon_indent_1',
            [
                'label' => __( 'Icon Spacing', 'hotelier-elements' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 50,
                    ],
                ],
                'condition' => [
                    'button_text_1!' => '',
                ],
            ]
        );

        $repeater->add_responsive_control(
            'animation_button_1',
            [
                'label' => __( 'Animation', 'hotelier-elements'),
                'type' => Controls_Manager::SELECT,
                'default' => 'fadeInUp',
                'options' => [
                    '' => __( 'None', 'hotelier-elements'),
                    'fadeInDown' => __( 'Down', 'hotelier-elements'),
                    'fadeInUp' => __( 'Up', 'hotelier-elements'),
                    'fadeInRight' => __( 'Right', 'hotelier-elements'),
                    'fadeInLeft' => __( 'Left', 'hotelier-elements'),
                    'zoomIn' => __( 'Zoom', 'hotelier-elements'),
                ],
                'condition' => [
                    'button_text_1!' => '',
                ],
            ]
        );

        $repeater->add_control(
            'animation_duration_button_1',
            [
                'label' => __( 'Animation Duration', 'hotelier-elements'),
                'type' => Controls_Manager::SELECT,
                'default' => '',
                'options' => [
                    'slow' => __( 'Slow', 'hotelier-elements'),
                    '' => __( 'Normal', 'hotelier-elements'),
                    'fast' => __( 'Fast', 'hotelier-elements'),
                ],
                'prefix_class' => 'animated-',
                'condition' => [
                    'animation_button_1!' => '',
                ],
            ]
        );

        $repeater->add_control(
            'animation_delay_button_1',
            [
                'label' => __( 'Animation Delay', 'hotelier-elements' ) . ' (ms)',
                'type' => Controls_Manager::NUMBER,
                'default' => '',
                'min' => 0,
                'step' => 100,
                'condition' => [
                    'animation_button_1!' => '',
                ],
                'render_type' => 'none',
                'frontend_available' => true,
            ]
        );

        $repeater->add_control(
            'button-2',
            [
                'label' => __( 'Button 2', 'hotelier-elements'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $repeater->add_control(
            'button_text_2',
            [
                'label' => __( 'Text', 'hotelier-elements' ),
                'type' => Controls_Manager::TEXT,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => __( '', 'hotelier-elements' ),
                'placeholder' => __( '', 'hotelier-elements' ),
            ]
        );

        $repeater->add_control(
            'button_link_2',
            [
                'label' => __( 'Link', 'hotelier-elements' ),
                'type' => Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => __( 'https://your-link.com', 'hotelier-elements' ),
                'default' => [
                    'url' => '#',
                ],
                'condition' => [
                    'button_text_2!' => '',
                ],
            ]
        );

        $repeater->add_responsive_control(
            'button_align_2',
            [
                'label' => __( 'Alignment', 'hotelier-elements' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left'    => [
                        'title' => __( 'Left', 'hotelier-elements' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', 'hotelier-elements' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __( 'Right', 'hotelier-elements' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                    'justify' => [
                        'title' => __( 'Justified', 'hotelier-elements' ),
                        'icon' => 'eicon-text-align-justify',
                    ],
                ],
                'prefix_class' => 'elementor%s-align-',
                'default' => '',
                'condition' => [
                    'button_text_2!' => '',
                ],
            ]
        );

        $repeater->add_control(
            'button_icon_2',
            [
                'label' => __( 'Icon', 'hotelier-elements' ),
                'type' => Controls_Manager::SELECT2,
                'multiple' => '',
                'default' => 'none',
                'options' => [
                    "none" => __('None','hotelier-elements'),
                    "angle-double-down" => __('angle-double-down','hotelier-elements'),
                    "angle-double-left" => __('angle-double-left','hotelier-elements'),
                    "angle-double-right" => __('angle-double-right','hotelier-elements'),
                    "angle-double-up" => __('angle-double-up','hotelier-elements'),
                    "angle-down" => __('angle-down','hotelier-elements'),
                    "angle-left" => __('angle-left','hotelier-elements'),
                    "angle-right" => __('angle-right','hotelier-elements'),
                    "angle-up" => __('angle-up','hotelier-elements'),
                    "arrow-alt-circle-down" => __('arrow-alt-circle-down','hotelier-elements'),
                    "arrow-alt-circle-left" => __('arrow-alt-circle-left','hotelier-elements'),
                    "arrow-alt-circle-right" => __('arrow-alt-circle-right','hotelier-elements'),
                    "arrow-alt-circle-up" => __('arrow-alt-circle-up','hotelier-elements'),
                    "arrow-circle-down" => __('arrow-circle-down','hotelier-elements'),
                    "arrow-circle-left" => __('arrow-circle-left','hotelier-elements'),
                    "arrow-circle-right" => __('arrow-circle-right','hotelier-elements'),
                    "arrow-circle-up" => __('arrow-circle-up','hotelier-elements'),
                    "arrow-down" => __('arrow-down','hotelier-elements'),
                    "arrow-left" => __('arrow-left','hotelier-elements'),
                    "arrow-right" => __('arrow-right','hotelier-elements'),
                    "arrow-up" => __('arrow-up','hotelier-elements'),
                    "arrows-alt" => __('arrows-alt','hotelier-elements'),
                    "arrows-alt-h" => __('arrows-alt-h','hotelier-elements'),
                    "arrows-alt-v" => __('arrows-alt-v','hotelier-elements'),
                    "caret-down" => __('caret-down','hotelier-elements'),
                    "caret-left" => __('caret-left','hotelier-elements'),
                    "caret-right" => __('caret-right','hotelier-elements'),
                    "caret-square-down" => __('caret-square-down','hotelier-elements'),
                    "caret-square-left" => __('caret-square-left','hotelier-elements'),
                    "caret-square-right" => __('caret-square-right','hotelier-elements'),
                    "caret-square-up" => __('caret-square-up','hotelier-elements'),
                    "caret-up" => __('caret-up','hotelier-elements'),
                    "chevron-circle-down" => __('chevron-circle-down','hotelier-elements'),
                    "chevron-circle-left" => __('chevron-circle-left','hotelier-elements'),
                    "chevron-circle-right" => __('chevron-circle-right','hotelier-elements'),
                    "chevron-circle-up" => __('chevron-circle-up','hotelier-elements'),
                    "chevron-down" => __('chevron-down','hotelier-elements'),
                    "chevron-left" => __('chevron-left','hotelier-elements'),
                    "chevron-right" => __('chevron-right','hotelier-elements'),
                    "chevron-up" => __('chevron-up','hotelier-elements'),
                    "long-arrow-alt-down" => __('long-arrow-alt-down','hotelier-elements'),
                    "long-arrow-alt-left" => __('long-arrow-alt-left','hotelier-elements'),
                    "long-arrow-alt-right" => __('long-arrow-alt-right','hotelier-elements'),
                    "long-arrow-alt-up" => __('long-arrow-alt-up','hotelier-elements'),
                    "minus" => __('minus','hotelier-elements'),
                    "minus-circle" => __('minus-circle','hotelier-elements'),
                    "minus-square" => __('minus-square','hotelier-elements'),
                    "plus" => __('plus','hotelier-elements'),
                    "plus-circle" => __('plus-circle','hotelier-elements'),
                    "plus-square" => __('plus-square','hotelier-elements'),
                ],
                'condition' => [
                    'button_text_2!' => '',
                ],
            ]
        );

        $repeater->add_control(
            'button_icon_align_2',
            [
                'label' => __( 'Icon Position', 'hotelier-elements' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'left',
                'options' => [
                    'left' => __( 'Before', 'hotelier-elements' ),
                    'right' => __( 'After', 'hotelier-elements' ),
                ],
                'condition' => [
                    'button_icon_2[value]!' => '',
                ],
            ]
        );

        $repeater->add_control(
            'button_icon_indent_2',
            [
                'label' => __( 'Icon Spacing', 'hotelier-elements' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 50,
                    ],
                ],
                'condition' => [
                    'button_text_2!' => '',
                ],
            ]
        );

        $repeater->add_responsive_control(
            'animation_button_2',
            [
                'label' => __( 'Animation', 'hotelier-elements'),
                'type' => Controls_Manager::SELECT,
                'default' => 'fadeInUp',
                'options' => [
                    '' => __( 'None', 'hotelier-elements'),
                    'fadeInDown' => __( 'Down', 'hotelier-elements'),
                    'fadeInUp' => __( 'Up', 'hotelier-elements'),
                    'fadeInRight' => __( 'Right', 'hotelier-elements'),
                    'fadeInLeft' => __( 'Left', 'hotelier-elements'),
                    'zoomIn' => __( 'Zoom', 'hotelier-elements'),
                ],
                'condition' => [
                    'button_text_2!' => '',
                ],
            ]
        );

        $repeater->add_control(
            'animation_duration_button_2',
            [
                'label' => __( 'Animation Duration', 'hotelier-elements'),
                'type' => Controls_Manager::SELECT,
                'default' => '',
                'options' => [
                    'slow' => __( 'Slow', 'hotelier-elements'),
                    '' => __( 'Normal', 'hotelier-elements'),
                    'fast' => __( 'Fast', 'hotelier-elements'),
                ],
                'prefix_class' => 'animated-',
                'condition' => [
                    'animation_button_2!' => '',
                ],
            ]
        );

        $repeater->add_control(
            'animation_delay_button_2',
            [
                'label' => __( 'Animation Delay', 'hotelier-elements' ) . ' (ms)',
                'type' => Controls_Manager::NUMBER,
                'default' => '',
                'min' => 0,
                'step' => 100,
                'condition' => [
                    'animation_button_2!' => '',
                ],
                'render_type' => 'none',
                'frontend_available' => true,
            ]
        );

        $repeater->add_control(
            'image_heading',
            [
                'label' => __( 'Image heading', 'hotelier-elements'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $repeater->add_control(
            'image',
            [
                'label' => __('Choose Image', 'hotelier-elements'),
                'type' => Controls_Manager::MEDIA,
                'dynamic' => [
                    'active' => false,
                ],
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );        

        $this->add_control(
            'sliders',
            [
                'label' => '',
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'heading' => __('Bootstrap touch slider', 'hotelier-elements'),
                        'description' => __('Make Bootstrap Better together.', 'hotelier-elements'),
                    ],
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'box_text_style',
            [
                'label' => __('Box Text', 'hotelier-elements'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_heading',
            [
                'label' => __( 'Title', 'hotelier-elements'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'title_spacing_bottom',
            [
                'label' => __( 'Spacing', 'hotelier-elements'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '.elementor-nb_slider-wrapper .box-text h2' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => __( 'Color', 'hotelier-elements'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '.elementor-nb_slider-wrapper .box-text h2' => 'color: {{VALUE}};',
                ],
                'scheme' => [
                    'type' => Schemes\Color::get_type(),
                    'value' => Schemes\Color::COLOR_1,
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '.elementor-nb_slider-wrapper .box-text h2',
                'scheme' => Schemes\Typography::TYPOGRAPHY_1,
            ]
        );

        $this->add_control(
            'description',
            [
                'label' => __( 'Excerpt', 'hotelier-elements'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'description_spacing_bottom',
            [
                'label' => __( 'Spacing', 'hotelier-elements'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '.elementor-nb_slider-wrapper .box-text .description' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'description_color',
            [
                'label' => __( 'Color', 'hotelier-elements'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '.elementor-nb_slider-wrapper .box-text .description' => 'color: {{VALUE}};',
                ],
                'scheme' => [
                    'type' => Schemes\Color::get_type(),
                    'value' => Schemes\Color::COLOR_1,
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'description_typography',
                'selector' => '.elementor-nb_slider-wrapper .box-text .description',
                'scheme' => Schemes\Typography::TYPOGRAPHY_2,
            ]
        );

        $this->end_controls_section();
        $this->start_controls_section(
            'button_1_style',
            [
                'label' => __('Button 1', 'hotelier-elements'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'button_1_typography',
                'scheme' => Schemes\Typography::TYPOGRAPHY_4,
                'selector' => '.elementor-nb_slider-wrapper .button_1 a',
            ]
        );

        $this->add_group_control(
            Group_Control_Text_Shadow::get_type(),
            [
                'name' => 'button_1_text_shadow',
                'selector' => '.elementor-nb_slider-wrapper .button_1 a',
            ]
        );

        $this->start_controls_tabs( 'tabs_button_style' );

        $this->start_controls_tab(
            'tab_button_1_normal',
            [
                'label' => __( 'Normal', 'hotelier-elements' ),
            ]
        );

        $this->add_control(
            'button_text_1_color',
            [
                'label' => __( 'Text Color', 'hotelier-elements' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '.elementor-nb_slider-wrapper .button_1 a' => 'fill: {{VALUE}}; color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_1_background_color',
            [
                'label' => __( 'Background Color', 'hotelier-elements' ),
                'type' => Controls_Manager::COLOR,
                'scheme' => [
                    'type' => Schemes\Color::get_type(),
                    'value' => Schemes\Color::COLOR_4,
                ],
                'selectors' => [
                    '.elementor-nb_slider-wrapper .button_1' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'button_1_tab_hover',
            [
                'label' => __( 'Hover', 'hotelier-elements' ),
            ]
        );

        $this->add_control(
            'button_1_hover_color',
            [
                'label' => __( 'Text Color', 'hotelier-elements' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '.elementor-nb_slider-wrapper .button_1 a:hover, .elementor-nb_slider-wrapper .button_1 a:focus' => 'color: {{VALUE}};',
                    '.elementor-nb_slider-wrapper .button_1 a:hover svg, .elementor-nb_slider-wrapper .button_1 a:focus svg' => 'fill: {{VALUE}};',
                    '.elementor-nb_slider-wrapper .button_1 a:hover i, .elementor-nb_slider-wrapper .button_1 a:focus i' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_1_background_hover_color',
            [
                'label' => __( 'Background Color', 'hotelier-elements' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '.elementor-nb_slider-wrapper .button_1:hover, .elementor-nb_slider-wrapper .button_1:focus' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_1_hover_border_color',
            [
                'label' => __( 'Border Color', 'hotelier-elements' ),
                'type' => Controls_Manager::COLOR,
                // 'condition' => [
                //     'button_1_border!' => '',
                // ],
                'selectors' => [
                    '.elementor-nb_slider-wrapper .button_1:hover, .elementor-nb_slider-wrapper .button_1:focus' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'button_1_border',
                'selector' => '.elementor-nb_slider-wrapper .button_1',
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'button_1_border_radius',
            [
                'label' => __( 'Border Radius', 'hotelier-elements' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '.elementor-nb_slider-wrapper .button_1' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'button_1_box_shadow',
                'selector' => '.elementor-nb_slider-wrapper .button_1',
            ]
        );

        $this->add_responsive_control(
            'button_1_text_padding',
            [
                'label' => __( 'Padding', 'hotelier-elements' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '.elementor-nb_slider-wrapper .button_1' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'separator' => 'before',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'button_2_style',
            [
                'label' => __('Button 2', 'hotelier-elements'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'button_2_typography',
                'scheme' => Schemes\Typography::TYPOGRAPHY_4,
                'selector' => '.elementor-nb_slider-wrapper .button_2 a',
            ]
        );

        $this->add_group_control(
            Group_Control_Text_Shadow::get_type(),
            [
                'name' => 'button_2_text_shadow',
                'selector' => '.elementor-nb_slider-wrapper .button_2 a',
            ]
        );

        $this->start_controls_tabs( 'tabs_button_style_2' );

        $this->start_controls_tab(
            'tab_button_2_normal',
            [
                'label' => __( 'Normal', 'hotelier-elements' ),
            ]
        );

        $this->add_control(
            'button_text_2_color',
            [
                'label' => __( 'Text Color', 'hotelier-elements' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '.elementor-nb_slider-wrapper .button_2 a' => 'fill: {{VALUE}}; color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_2_background_color',
            [
                'label' => __( 'Background Color', 'hotelier-elements' ),
                'type' => Controls_Manager::COLOR,
                'scheme' => [
                    'type' => Schemes\Color::get_type(),
                    'value' => Schemes\Color::COLOR_4,
                ],
                'selectors' => [
                    '.elementor-nb_slider-wrapper .button_2' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'button_2_tab_hover',
            [
                'label' => __( 'Hover', 'hotelier-elements' ),
            ]
        );

        $this->add_control(
            'button_2_hover_color',
            [
                'label' => __( 'Text Color', 'hotelier-elements' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '.elementor-nb_slider-wrapper .button_2 a:hover, .elementor-nb_slider-wrapper .button_2 a:focus' => 'color: {{VALUE}};',
                    '.elementor-nb_slider-wrapper .button_2 a:hover svg, .elementor-nb_slider-wrapper .button_2 a:focus svg' => 'fill: {{VALUE}};',
                    '.elementor-nb_slider-wrapper .button_2 a:hover i, .elementor-nb_slider-wrapper .button_2 a:focus i' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_2_background_hover_color',
            [
                'label' => __( 'Background Color', 'hotelier-elements' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '.elementor-nb_slider-wrapper .button_2:hover, .elementor-nb_slider-wrapper .button_2:focus' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_2_hover_border_color',
            [
                'label' => __( 'Border Color', 'hotelier-elements' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '.elementor-nb_slider-wrapper .button_2:hover, .elementor-nb_slider-wrapper .button_2:focus' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'button_2_border',
                'selector' => '.elementor-nb_slider-wrapper .button_2',
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'button_2_border_radius',
            [
                'label' => __( 'Border Radius', 'hotelier-elements' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '.elementor-nb_slider-wrapper .button_2' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'button_2_box_shadow',
                'selector' => '.elementor-nb_slider-wrapper .button_2',
            ]
        );

        $this->add_responsive_control(
            'button_2_text_padding',
            [
                'label' => __( 'Padding', 'hotelier-elements' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '.elementor-nb_slider-wrapper .button_2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'separator' => 'before',
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>
        <div class="elementor-nb_slider-wrapper swiper swiper-container">
            <div class="swiper-wrapper">
                <?php foreach ($settings['sliders'] as $key => $item) : ?>
                    <div class="swiper-slide">
                        <div class="col-inner">
                            <div class="box-image">
                                <div class="image" style="background-image: url(<?php echo esc_url($item['image']['url']) ?>)">
                                </div>
                            </div>
                            <div class="box-text <?php echo $item['vertical']; echo " "; echo $item['horizontal']; echo ' text-'.$item['text_align']; ?>">
                                <div class="text-inner">
                                    <h2 data-heading-animation="<?php echo $item["animation_heading"] ?>" data-heading-animation-delay="<?php echo $item["animation_delay_heading"] ?>" class="heading index-<?php echo $key; ?><?php echo $item['animation_heading'] ? ' animated '.$item['animation_heading'] : '' ?><?php echo $item['animation_duration_heading'] ? ' animated-'.$item['animation_duration_heading'] : '' ?>"><?php echo esc_attr($item['heading']) ?></h2>
                                    <p data-description-animation="<?php echo $item["animation_description"] ?>" data-description-animation-delay="<?php echo $item["animation_delay_description"] ?>" class="description index-<?php echo $key; ?><?php echo $item['animation_description'] ? ' animated '.$item['animation_description'] : '' ?><?php echo $item['animation_duration_description'] ? ' animated-'.$item['animation_duration_description'] : '' ?>"><?php echo esc_attr($item['description']) ?></p>
                                </div>
                                <?php
                                $buttonAlign = "";
                                if ($item['text_align'] === 'left') {
                                    $buttonAlign = "justify-content-start";
                                }elseif ($item['text_align'] === 'right') {
                                    $buttonAlign = "justify-content-end";
                                }else {
                                    $buttonAlign = "justify-content-center";
                                }

                                ?>
                                <div class="button-inner <?php echo $buttonAlign; ?>">
                                    <?php if ( !empty( $item['button_text_1'] ) ): ?>
                                        <div data-button-1-animation="<?php echo $item["animation_button_1"] ?>" data-button-1-animation-delay="<?php echo $item["animation_delay_button_1"] ?>" class="button_1 index-<?php echo $key; ?><?php echo $item['animation_button_1'] ? ' animated '.$item['animation_button_1'] : '' ?><?php echo $item['animation_duration_button_1'] ? ' animated-'.$item['animation_duration_button_1'] : '' ?>"><a class="d-flex align-items-center justify-content-center <?php echo $item['button_icon_align_1'] == 'left' ? 'flex-row-reverse' : '' ?>" href="<?php echo esc_url($item['button_link_1']['url']);?>"><span><?php echo esc_attr($item['button_text_1']) ?></span><i style="<?php echo $item['button_icon_align_1'] == 'right' ? 'padding-left:'.($item['button_icon_indent_1']['size'] ? $item['button_icon_indent_1']['size'].'px' : '0px') : 'padding-right:'.($item['button_icon_indent_1']['size'] ? $item['button_icon_indent_1']['size'].'px':'0px'); ?>" class="fa fa-<?php echo $item['button_icon_1']; ?>"></i></a></div>
                                    <?php endif ?>
                                    <?php if ( !empty( $item['button_text_2'] ) ): ?>
                                        <div data-button-2-animation="<?php echo $item["animation_button_2"] ?>" data-button-2-animation-delay="<?php echo $item["animation_delay_button_2"] ?>" class="button_2 index-<?php echo $key; ?><?php echo $item['animation_button_2'] ? ' animated '.$item['animation_button_2'] : '' ?><?php echo $item['animation_duration_button_2'] ? ' animated-'.$item['animation_duration_button_2'] : '' ?>"><a class="d-flex align-items-center justify-content-center <?php echo $item['button_icon_align_2'] == 'left' ? 'flex-row-reverse' : '' ?>" href="<?php echo esc_url($item['button_link_2']['url']);?>"><span><?php echo esc_attr($item['button_text_2']) ?></span><i style="<?php echo $item['button_icon_align_2'] == 'right' ? 'padding-left:'.($item['button_icon_indent_2']['size']?$item['button_icon_indent_2']['size'].'px':'0px') : 'padding-right:'.($item['button_icon_indent_2']['size']?$item['button_icon_indent_2']['size'].'px':'0px'); ?>" class="fa fa-<?php echo $item['button_icon_2']; ?>"></i></a></div>
                                    <?php endif ?>
                                </div>
                            </div> 
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
            <div class="swiper-pagination"></div>
            <div class="swiper-button-prev"></div>
            <div class="swiper-button-next"></div>
        </div>
        <?php 
    }

}


\Elementor\Plugin::instance()->widgets_manager->register_widget_type(new NB_Widget_Slider_Animation_Swiper());