<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class NB_Icon_Box_Custom_Elementor extends Widget_Base {

	public function get_name() {
		return 'nb-ion-box-elementor';
	}

	public function get_title() {
		return __( 'Icon Box Icomoon', 'hotelier-elements' );
	}

	public function get_icon() {
		return 'eicon-info-box';
	}

	public function get_categories() {
		return [ 'hotelier-elements' ];
	}

	public function get_script_depends() {
		return [ 'hotelier-elements' ];
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'Content', 'hotelier-elements' ),
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'title',
			[
				'label' => __( 'Name', 'hotelier-elements' ),
				'type' => Controls_Manager::TEXT,
			]
		);

		$repeater->add_control(
			'description',
			[
				'label' => __( 'Description', 'hotelier-elements' ),
				'type' => Controls_Manager::TEXT,
			]
		);

		$repeater->add_control(
			'icon',
			[
				'label' => __( 'Icon', 'hotelier-elements' ),
				'type' => Controls_Manager::SELECT,
				'default' => '',
				'options' => [
					'support' => 'Support',
					'agent' => 'Agent',
					'heart' => 'Heart',
					'home-run' => 'Home',
					'pig' => 'Pig',
					'plane' => 'Plane',
				],
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'icon_box_list',
			[
				'label' => __( 'Icon box List', 'hotelier-elements' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
			]
		);

		$this->add_control(
			'show_pagination',
			[
				'label' => __( 'Show Pagination', 'hotelier-elements' ),
				'type' => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_navigation',
			[
				'label' => __( 'Show Navigation', 'hotelier-elements' ),
				'type' => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->end_controls_section();

	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$show_pagination    = $settings['show_pagination'];
		$show_navigation    = $settings['show_navigation'];
		?>
		<div class="elementor-nb_icon_box-wrapper">
			<div class="row row-0">
				<?php foreach ($settings['icon_box_list'] as $key => $item) : ?>
					<div class="col-xs-6 col-sm-4 col-xl-2">
						<div class="item">
							<div class="col-inner">
								<div class="box-icon">
									<span class="icon-<?php echo esc_attr($item['icon']) ?>"></span>
								</div>
								<div class="box-text">
									<div class="text-inner">
										<p><?php echo esc_attr($item['title']) ?></p>
									</div>
								</div>
							</div>
						</div>
					</div>
				<?php endforeach; ?>
			</div>
			<?php if ($show_pagination) : ?>
	            <div class="swiper-pagination"></div>
	        <?php endif; ?>

	        <?php if ($show_navigation) : ?>
	            <div class="swiper-button-next"></div>
	            <div class="swiper-button-prev"></div>
	        <?php endif; ?>
		</div>
		<?php
	}
}

\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new NB_Icon_Box_Custom_Elementor() );