<?php 

$style          = $settings['style'];
$style_class    = 'nb-blog-' . $style;
$excerpt_length = $settings['excerpt_length'];

$query_args = array(
    'post_type' => 'post',
    'post_status' => 'publish',
    'posts_per_page' => $settings['posts_per_page']
);

$nb_posts = new WP_Query($query_args);
$totalPosts = count($nb_posts->posts);
if( $totalPosts < $settings['posts_per_page'] ) {
    $close = $totalPosts - 1 ;
}else {
    $close = $settings['posts_per_page'] - 1;
}
if ($style=='style_2'):?>
<div class="nb-post-wrapper <?php echo esc_attr($style_class);?>">
    <div class="row">
        <?php $i = 0; while ($nb_posts->have_posts()) : $nb_posts->the_post();?>
          <?php if ($i == '0'): ?>  
        <div class="col-md-6 col-lg-6">
            <div class="nb-post-item-wrapper">
                <div class="nb-post-item">
                    <?php
                        $featured_img_url = get_the_post_thumbnail_url(get_the_ID(), 'medium_large ');
                    ?>
                    <div class="nb-post-thumbnail">
                        <a href="<?php echo get_the_permalink(); ?>" style="background-image:url(<?php echo $featured_img_url; ?>);"></a>
                    </div>

                    <div class="nb-post-data">

                        <div class="nb-post-date">
                            <span class="icon-calendar-1"></span>
                            <?php echo date_i18n('F j, Y', strtotime(get_the_date('',get_the_ID()))); ?>
                        </div>

                        <h4 class="nb-post-title"><a href="<?php echo get_the_permalink(); ?>" rel="bookmark">
                            <?php echo get_the_title(get_the_ID()); ?>
                        </a></h4>
                        <div class="nb-content">
                            <?php
                            if (has_excerpt()):
                                echo '<p >' . (absint($excerpt_length) > 0 ? wp_trim_words(get_the_excerpt(), $excerpt_length, '...') : get_the_excerpt()) . '</p>';
                            else :
                                echo '<p>' . (absint($excerpt_length) > 0 ? wp_trim_words(get_the_content(), $excerpt_length, '...') : get_the_content()) . '</p>';
                            endif;
                            ?>
                        </div>
                        <div class="read-more-link">
                            <a href="<?php echo get_permalink(); ?>"><?php echo esc_html__('Read More', 'hotelier-elements'); ?></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>  
        <?php $i++; ?>
        <?php endwhile;?>
        <?php echo '<div class="col-md-6 col-lg-6 post-content-right">'; ?>
        <div class="row">
        <?php $j = 0; while ($nb_posts->have_posts()) : $nb_posts->the_post();?>
        <?php if ($j != '0'): ?>  
            <div class="col-12">
                <div class="nb-post-item-wrapper">
                    <div class="nb-post-item">
                        <?php
                            $featured_img_url = get_the_post_thumbnail_url(get_the_ID(), 'medium_large ');
                        ?>
                        <div class="nb-post-thumbnail">
                            <a href="<?php echo get_the_permalink(); ?>" style="background-image:url(<?php echo $featured_img_url; ?>);"></a>
                            
                        </div>

                        <div class="nb-post-data">

                            <div class="nb-post-date">
                                <span class="icon-calendar-1"></span>
                                <?php echo date_i18n('F j, Y', strtotime(get_the_date(''))); ?>
                            </div>

                            <h4 class="nb-post-title"><a href="<?php echo get_the_permalink(); ?>" rel="bookmark">
                                <?php echo get_the_title(); ?>
                            </a></h4>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>  
        <?php $j++; ?>
        <?php endwhile;?>
        <?php echo '</div>'; ?>
        </div>
    </div>
</div>
<?php
else:
?>

<div class="nb-post-wrapper <?php echo esc_attr($style_class);?>">
    <?php while ($nb_posts->have_posts()) : $nb_posts->the_post();?>
        <div class="nb-post-item-wrapper">
            <?php if($style == 'style_1'):?>
                <div class="nb-post-item">
                    <?php
                        $featured_img_url = get_the_post_thumbnail_url(get_the_ID(), 'medium_large ');
                    ?>
                    <div class="nb-post-thumbnail">
                        <a href="<?php the_permalink(); ?>" style="background-image:url(<?php echo $featured_img_url; ?>);"></a>
                        
                    </div>

                    <div class="nb-post-data">

                        <div class="nb-post-date">
                            <span class="icon-calendar-1"></span>
                            <?php echo date_i18n('F j, Y', strtotime(get_the_date(''))); ?>
                        </div>

                        <?php the_title( '<h4 class="nb-post-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h4>' );?>

                        <div class="nb-content">
                            <?php
                            if (has_excerpt()) :
                                echo '<p >' . (absint($excerpt_length) > 0 ? wp_trim_words(get_the_excerpt(), $excerpt_length, '...') : get_the_excerpt()) . '</p>';
                            else :
                                echo '<p>' . (absint($excerpt_length) > 0 ? wp_trim_words(get_the_content(), $excerpt_length, '...') : get_the_content()) . '</p>';
                            endif;
                            ?>
                        </div>
                        <div class="read-more-link">
                            <a href="<?php echo get_permalink(); ?>"><?php echo esc_html__('Read More', 'retreatclub-elements'); ?></a>
                            <i class="icon-double-right-arrow"></i>
                        </div>
                    </div>
                </div>
            <?php else:?>
                <div class="nb-post-item">
                    <?php
                        $featured_img_url = get_the_post_thumbnail_url(get_the_ID(), 'medium_large ');
                    ?>
                    <div class="nb-post-thumbnail">
                        <a href="<?php the_permalink(); ?>" style="background-image:url(<?php echo $featured_img_url; ?>);"></a>
                        <div class="nb-post-date">
                        <span class="icon-calendar-1"></span>
                        <?php echo date_i18n('F j, Y', strtotime(get_the_date(''))); ?>
                    </div>
                    </div>

                    <div class="nb-post-data">
                        <?php the_title( '<h4 class="nb-post-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h4>' );?>

                        <div class="nb-content">
                            <?php
                            if (has_excerpt()) :
                                echo '<p >' . (absint($excerpt_length) > 0 ? wp_trim_words(get_the_excerpt(), $excerpt_length, '...') : get_the_excerpt()) . '</p>';
                            else :
                                echo '<p>' . (absint($excerpt_length) > 0 ? wp_trim_words(get_the_content(), $excerpt_length, '...') : get_the_content()) . '</p>';
                            endif;
                            ?>
                        </div>
                        <div class="read-more-link">
                            <a href="<?php echo get_permalink(); ?>"><?php echo esc_html__('Read More', 'hotelier-elements'); ?></a>
                        </div>
                    </div>
                </div>
            <?php endif;?>
        </div>
    <?php endwhile;?>
    <?php wp_reset_postdata();?>
</div>
<?php endif;?>