<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class NB_Blog_Elementor extends Widget_Base {

	public function get_name() {
		return 'nb-blog-elementor';
	}

	public function get_title() {
		return __( 'Blog', 'retreatclub-elements' );
	}

	public function get_icon() {
		return 'eicon-posts-grid';
	}

	public function get_categories() {
		return [ 'retreatclub-elements' ];
	}

	public function get_script_depends() {
		return [ 'retreatclub-elements' ];
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'Content', 'retreatclub-elements' ),
			]
		);

		$this->add_control(
			'style',
			[
				'label' => __( 'Style', 'retreatclub-elements' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'style_1',
				'options' => [
					'style_1'  => __( 'Style 1', 'retreatclub-elements' ),					
					'style_2' => __( 'Style 2', 'retreatclub-elements' ),
					'style_3' => __( 'Style 3', 'retreatclub-elements' ),
				],
			]
		);

		$this->add_control(
			'posts_per_page',
			[
				'label' => __( 'Posts per page', 'retreatclub-elements' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 2,
				'max' => 10,
				'step' => 1,
				'default' => 3,
			]
		);

		$this->add_control(
			'excerpt_length',
			[
				'label' => __( 'Excerpt Length', 'retreatclub-elements' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 10,
				'max' => 100,
				'step' => 1,
				'default' => 20,
			]
		);

		$this->end_controls_section();

	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

		$template_path = TP_ELEMENTS_PATH . '/elementor_widgets/blog/template.php';

		require $template_path;
	}

	/**
	 * Render the widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function _content_template() {
		?>
		<div class="title">
			{{{ settings.title }}}
		</div>
		<?php
	}
}

\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new NB_Blog_Elementor() );
