"use strict";
(function ($) {
    $.view_list_hotels = function (element, options) {
        let defaults = {
            render_hotel_grid:"",
            render_hotel_list:"",
            items_per_page: 9,
            visiblePages: 3,
        };
        var wrapHeight = $('.data-listservice-ajax').height() + $('.data-listservice-ajax').offset().top;
        let plugin = this;
        plugin.settings = {}
        let $element = $(element);
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            $element.find('select.block-sort').select2();
            let nowDate = new Date();
            let today = new Date(nowDate.getFullYear(), nowDate.getMonth(), nowDate.getDate(), 0, 0, 0, 0);
            $element.find('input[id="check-in"]').on('change', function () {
                let date = moment($element.find('input[id="check-in"]').val(), "YYYY-MM-DD").add(1, 'd');
                $element.find('input[id="check-out"]').data('daterangepicker').minDate = date;
                $element.find('input[id="check-out"]').data('daterangepicker').startDate = date;
                $element.find('input[id="check-out"]').val(date.format("YYYY-MM-DD"));
                $element.find('input[name="check_out"]').val(date.format("YYYY-MM-DD"));
            });
            $element.find('input[id="check-out"]').on('change', function () {
                let date = moment($element.find('input[id="check-out"]').val(), "YYYY-MM-DD").subtract(1, 'd');
                $element.find('input[id="check-in"]').data('daterangepicker').maxDate = date;
            });
            /*
             * Ajax filter list hotels
             */
            

            var filterAjaxEvent = plugin.debounce(function () {
                $element.find('input[name="limit1"]').val(12);
                $element.find('input[name="start"]').val(0);
                $element.find('#pagination-hotels-ajax').hide()
                var output = plugin.convert_data_form();
                let dataObj = {};
                $(output).each(function(i, field){
                    if( field.name == 'start' ){
                        dataObj[field.name] = 0;
                    }else if( field.name == 'limit1' ){
                        dataObj[field.name] = 12;
                    }else {
                        dataObj[field.name] = field.value;
                    }
                });
                plugin.filter_ajax(dataObj);
            }, 300);
            var filterAjaxEventLoadMore = plugin.debounce(function () {
                var output = plugin.convert_data_form();
                let dataObj = {};
                $(output).each(function(i, field){
                    dataObj[field.name] = field.value;
                });
                plugin.filter_ajax(dataObj);
                $('html, body').animate({ scrollTop: wrapHeight }, 'slow');
            }, 300);
            var filterAjaxEventLoadMores = plugin.debounce(function () {
                var output = plugin.convert_data_form();
                let dataObj = {};
                $(output).each(function(i, field){
                    dataObj[field.name] = field.value;
                });
                plugin.loadmore_ajax(dataObj);
            }, 300);
            var tabAjaxEvent = plugin.debounce(function () {
                var output = plugin.convert_data_form();
                let dataObj = {};
                $(output).each(function(i, field){
                    dataObj[field.name] = field.value;
                });
                plugin.tab_ajax(dataObj);
            }, 300);
            $element.find('.form-search-hotels input[name="keyword_address"]').on('keyup', filterAjaxEvent);
            $element.find('.form-search-hotels input#check-in').on('change', filterAjaxEvent);
            $element.find('.form-search-hotels input[name="check_in"]').on('change', filterAjaxEvent);
            $element.find('.form-search-hotels input#check-out').on('change', filterAjaxEvent);
            $element.find('.form-search-hotels input[name="check_out"]').on('change', filterAjaxEvent);
            $element.find('.form-search-hotels .btn-minius').on('click', filterAjaxEvent);
            $element.find('.form-search-hotels .btn-plus').on('click', filterAjaxEvent);
            $element.find('.form-search-hotels input.input-field').on('change', filterAjaxEvent);
            $element.find('.form-search-hotels input[name="rating[]"]').on('change', filterAjaxEvent);
            $element.find('.form-search-hotels input[name="room_type_id[]"]').on('change', filterAjaxEvent);
            $('body').on('click','.nav-tabs li', function() {
                let layout = $(this).data('layout');
                $(this).toggleClass('active');
                $element.find('input[name="tab"]').val(layout);
            })
            let limit=parseInt(plugin.settings.limit);
            $element.find('input[name="limit1"]').val(limit);
            let page = parseInt(plugin.settings.page);
            let start = parseInt(plugin.settings.start);
            $element.find('#pagination-hotels-ajax').on('click', function() {
                let input_limit = parseInt($element.find('input[name="limit1"]').val());
                let input_page = page;
                let input_start = parseInt($element.find('input[name="start"]').val());
                var output = plugin.convert_data_form();
                let dataObj = {};
                $(output).each(function(i, field){
                    dataObj[field.name] = field.value;
                });
                // if( dataObj['keyword_address'] == "" && dataObj['check_in'] == "" && dataObj['check_out'] == "" && dataObj['number_adult'] == "" && dataObj['number_child'] == "" && ( dataObj['rating'] == '' || dataObj['rating'] == undefined ) && ( dataObj['room_type_id[]'] == '' || dataObj['room_type_id[]'] == undefined ) ) {
                //     input_start = parseInt(input_start)+limit;
                //     $element.find('input[name="start"]').val(input_start);
                // }
                input_start = parseInt(input_start)+limit;
                $element.find('input[name="start"]').val(input_start);
                input_limit = parseInt(input_limit)+limit;
                $element.find('input[name="limit1"]').val(input_limit);
                input_page = parseInt(input_page)+page;
                $element.find('input[name="page"]').val(input_page);
            });
            $element.find('#pagination-hotels-ajax').on('click', filterAjaxEventLoadMores);
            $('body').on('click', '.nav-tabs li', tabAjaxEvent);
            $element.find('.sort-display a').click(function(){
                let sort=$(this).data('key_sort');
                let direction=$(this).data('direction');
                $element.find('input[name="key_sort"]').val(sort);
                $element.find('input[name="start"]').val(0);
                $element.find('input[name="direction"]').val(direction);
                $element.find('.sort-by-block .dropdown').removeClass('open');
            });  
            $element.find('.sort-display a').click(filterAjaxEvent);     
            $('body').on('click', '.sort-display a', function(){
                let sort=$(this).data('key_sort');
                let direction=$(this).data('direction');
                $element.find('input[name="key_sort"]').val(sort);
                $element.find('input[name="start"]').val(0);
                $element.find('input[name="direction"]').val(direction);
                $element.find('.sort-by-block .dropdown').removeClass('open');
            });      
            $('body').on('click', '.sort-display a', filterAjaxEvent);   
            /*
             * End Ajax filter list hotels
             */
            $('body').on('click','.heart',function(e){
                let $hotel_item = $(this).closest('.wishlist-item');
                let hotel_id = $hotel_item.data('hotel_id');
                let user_id = $hotel_item.data('user_id');
                let $wishlist_icon = $(this);
                if(user_id=="" && user_id==0){
                    if ( $('.alert-warning').length == 0){
                        $("body").append('<div class="alert alert-warning" role="alert" style="display: inline-block;position: fixed;right: 60px;top: 30px;z-index:999;" >Please login to use the feature!<button type="button" class="close" data-dismiss="alert" aria-label="Close" style="margin-left: 30px"><span aria-hidden="true">&times;</span></button></div>');
                        setTimeout(function(){
                            $('.alert-warning').remove();
                        },1500)
                    }
                    return;
                }
                let data = {
                    task: "wishlist.change_wishlist",
                    state: 1,
                    hotel_id: hotel_id,
                    user_id: user_id,
                };
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: wpbookinghotel_root_url + wpbookinghotel_api_task,
                    data: data,
                    beforeSend: function () {
                        $wishlist_icon.toggleClass("active");
                        $wishlist_icon.find('i').removeClass("fa-heart").addClass("fa-spinner fa-spin");
                    },
                    error: function (xhr) {

                    },
                    complete: function () {
                        $wishlist_icon.find('i').addClass("fa-heart").removeClass("fa-spinner fa-spin");
                    },
                    success: function (response) {
                        response = JSON.parse(response);
                    }
                });
            })
        };
        plugin.debounce = function(func, wait) {
            var timeout;

            return function() {
                var context = this,
                    args = arguments;

                var executeFunction = function() {
                    func.apply(context, args);
                };

                clearTimeout(timeout);
                timeout = setTimeout(executeFunction, wait);
            };
        };
        plugin.convert_data_form = function() {
            var dataArray = $element.find('.form-search-hotels').serializeArray();
            var output = [];
            dataArray.forEach(function(item) {
                var existing = output.filter(function(v, i) {
                    return v.name == item.name;
                });
                if (existing.length) {
                    var existingIndex = output.indexOf(existing[0]);
                    output[existingIndex].value = output[existingIndex].value.concat(item.value);
                } else {
                    if (typeof item.value == 'string')
                        item.value = [item.value];
                    output.push(item);
                }
            });
            return output;
        };
        plugin.filter_ajax = function(dataObj) {
            $.ajax({
                url: wpbookinghotel_root_url+wpbookinghotel_api_task,
                type: 'POST',
                dataType: 'json',
                data: {
                    dataObj: JSON.stringify(dataObj),
                    task: "hotels.get_list_services_ajax_form",
                    page_hotel_detail: plugin.settings.page_hotel_detail
                },
                beforeSend: function() {
                    $('body').loadingModal();
                },
                success: function(res) {
                    let data= JSON.parse(res);
                    if( data.data.template1 && data.data.template2) {
                            $element.find('.wrapper-hotel-list').empty(data.data.template2);
                            $element.find('.wrapper-hotel-grid').empty(data.data.template1);

                            $element.find('.wrapper-hotel-list').append(data.data.template2);
                            $element.find('.wrapper-hotel-grid').append(data.data.template1);
                    }
                    if(data.data.total) {
                        $element.find('#pagination-hotels-ajax').attr("data-total",data.data.total);
                        $element.find('input[name="total_item"]').val(data.data.total);
                        let limit1 = $element.find('input[name="limit1"]').val();
                        if( data.data.total > limit1 ) {
                            $element.find('#pagination-hotels-ajax').show();
                        }else {
                            $element.find('#pagination-hotels-ajax').hide();
                        }
                        $element.find('.count1').text(data.data.total_show);
                        $element.find('.count2').text(data.data.total);
                    }
                    var $direction = $element.find('input[name="direction"]').val();
                    var $sort = $element.find('input[name="key_sort"]').val();
                    if($direction === "ASC" && $sort === "a.name"){
                        $element.find('.select-by-default').text('Sort by name from A-Z');
                    } else if($direction === "DESC" && $sort === "a.name"){
                        $element.find('.select-by-default').text('Sort by name from Z-A');
                    } else if($direction === "ASC" && $sort === "a.price"){
                        $element.find('.select-by-default').text('Sort by ascending price');
                    } else if($direction === "DESC" && $sort === "a.price"){
                        $element.find('.select-by-default').text('Sort by descending price');
                    } else {
                        $element.find('.select-by-default').text('Sort by');
                    }
                },
                error: function(xhr) { // if error occured
                    
                },
                complete: function() {
                    $('body').loadingModal('destroy');
                    if (history.pushState) {
                        var $params = "";
                        $.each(dataObj, function(index, val) {

                            // if (index == 'start' || index == 'limit' || index == 'total_item' || index == 'page'){
                            //     delete dataObj[index];
                            // }else {
                            //     if( index == "keyword_address" ) {
                            //         $params += "?"+index+"="+val;
                            //     }
                            //     else if ( index == "layout") {
                            //         $params += "&"+index+"="+val;
                            //     }else if ( index == "rating[]") {
                            //         $params += "&rating="+val;
                            //     }
                            //     else {
                            //         $params += "&"+index+"="+val;
                            //     }
                            // }

                            if( index == "keyword_address" ) {
                                $params += "?"+index+"="+val;
                            }
                            else if ( index == "layout") {
                                $params += "&"+index+"="+val;
                            }else if ( index == "rating[]") {
                                $params += "&rating="+val;
                            }
                            else {
                                $params += "&"+index+"="+val;
                            }
                            
                        });
                        var newurl = window.location.protocol + "//" + window.location.host + window.location.pathname + $params;
                        window.history.pushState({path:newurl},'',newurl);
                    }
                },
            })                        
        };
        var y ;
        plugin.loadmore_ajax = function(dataObj) {
            $.ajax({
                url: wpbookinghotel_root_url+wpbookinghotel_api_task,
                type: 'POST',
                dataType: 'json',
                data: {
                    dataObj: JSON.stringify(dataObj),
                    task: "hotels.get_list_services_ajax_form",
                    page_hotel_detail: plugin.settings.page_hotel_detail
                },
                beforeSend: function() {
                    $('body').loadingModal();
                    $('#pagination-hotels-ajax i').addClass('fa-spinner fa-spin').css({
                        'position':'absolute',
                        'left':'50%',
                        'top':'50%',
                        'transform':'translate(-50%,-50%)',
                        'margin-top':'-7px',
                    });
                    $('#pagination-hotels-ajax span').css('opacity','0');
                     y = window.pageYOffset;
                },
                success: function(res) {
                    let data= JSON.parse(res);
                    if( data.data.template1 || data.data.template2) {
                            $element.find('.wrapper-hotel-list').append(data.data.template2);
                            $element.find('.wrapper-hotel-grid').append(data.data.template1);
                    }
                    if(data.data.total) {
                        $element.find('#pagination-hotels-ajax').attr("data-total",data.data.total);
                        $element.find('input[name="total_item"]').val(data.data.total);
                        let limit1 = $element.find('input[name="limit1"]').val();
                        if( data.data.total > limit1 ) {
                            $element.find('#pagination-hotels-ajax').show();
                        }else {
                            $element.find('#pagination-hotels-ajax').hide();
                        }
                        $element.find('.count1').text(data.data.total_show);
                        $element.find('.count2').text(data.data.total);
                    }
                    if(data.data.layout) {
                        $element.find('.nav-tabs li').each(function(index, el) {
                            $(el).removeClass('active');
                            if($(el).attr('data-layout') == data.data.layout) {
                                $(el).addClass('active');
                            }

                        });
                        $element.find('.tab-contents > div').each(function(index, el) {
                            $(el).removeClass('in active');
                            if($(el).attr('data-layout') == data.data.layout) {
                                $(el).addClass('in active');
                            }

                        });
                    }
                    var $direction = $element.find('input[name="direction"]').val();
                    var $sort = $element.find('input[name="key_sort"]').val();
                    if($direction === "ASC" && $sort === "a.name"){
                        $element.find('.select-by-default').text('Sort by name from A-Z');
                    } else if($direction === "DESC" && $sort === "a.name"){
                        $element.find('.select-by-default').text('Sort by name from Z-A');
                    } else if($direction === "ASC" && $sort === "a.price"){
                        $element.find('.select-by-default').text('Sort by ascending price');
                    } else if($direction === "DESC" && $sort === "a.price"){
                        $element.find('.select-by-default').text('Sort by descending price');
                    } else {
                        $element.find('.select-by-default').text('Sort by');
                    }
                },
                error: function(xhr) { // if error occured
                    
                },
                complete: function() {
                    $('body').loadingModal('destroy');
                    if (history.pushState) {
                        var $params = "";
                        $.each(dataObj, function(index, val) {

                            // if (index == 'start' || index == 'limit' || index == 'total_item' || index == 'page'){
                            //     delete dataObj[index];
                            // }else {
                            //     if( index == "keyword_address" ) {
                            //         $params += "?"+index+"="+val;
                            //     }
                            //     else if ( index == "layout") {
                            //         $params += "&"+index+"="+val;
                            //     }else if ( index == "rating[]") {
                            //         $params += "&rating="+val;
                            //     }
                            //     else {
                            //         $params += "&"+index+"="+val;
                            //     }
                            // }

                            if( index == "keyword_address" ) {
                                $params += "?"+index+"="+val;
                            }
                            else if ( index == "layout") {
                                $params += "&"+index+"="+val;
                            }else if ( index == "rating[]") {
                                $params += "&rating="+val;
                            }
                            else {
                                $params += "&"+index+"="+val;
                            }

                        });
                        var newurl = window.location.protocol + "//" + window.location.host + window.location.pathname + $params;
                        window.history.pushState({path:newurl},'',newurl);
                    }
                    $('#pagination-hotels-ajax i').removeClass('fa-spinner fa-spin');
                    $('#pagination-hotels-ajax span').css('opacity','1');
                    window.scrollTo(0,y);
                },
            })                        
        };
        plugin.tab_ajax = function(dataObj) {
            $.ajax({
                url: wpbookinghotel_root_url+wpbookinghotel_api_task,
                type: 'POST',
                dataType: 'json',
                data: {
                    dataObj: JSON.stringify(dataObj),
                    task: "hotels.get_list_services_ajax_form",
                    page_hotel_detail: plugin.settings.page_hotel_detail
                },
                beforeSend: function() {
                    $('body').loadingModal();
                },
                success: function(res) {
                    let data= JSON.parse(res);
                    if(data.data.layout) {
                        $element.find('.nav-tabs li').each(function(index, el) {
                            $(el).removeClass('active');
                            if($(el).attr('data-layout') == data.data.layout) {
                                $(el).addClass('active');
                            }

                        });
                        $element.find('.tab-contents > div').each(function(index, el) {
                            $(el).removeClass('in active');
                            if($(el).attr('data-layout') == data.data.layout) {
                                $(el).addClass('in active');
                            }

                        });
                    }
                    if(data.data.total) {
                        $element.find('#pagination-hotels-ajax').attr("data-total",data.data.total);
                        $element.find('input[name="total_item"]').val(data.data.total);
                        let limit1 = $element.find('input[name="limit1"]').val();
                        if( data.data.total > limit1 ) {
                            $element.find('#pagination-hotels-ajax').show();
                        }else {
                            $element.find('#pagination-hotels-ajax').hide();
                        }
                        $element.find('.count1').text(data.data.total_show);
                        $element.find('.count2').text(data.data.total);
                    }
                },
                error: function(xhr) { // if error occured
                    
                },
                complete: function() {
                    $('body').loadingModal('destroy');
                    if (history.pushState) {
                        var $params = "";
                        $.each(dataObj, function(index, val) {

                            // if (index == 'start' || index == 'limit' || index == 'total_item' || index == 'page'){
                            //     delete dataObj[index];
                            // }else {
                            //     if( index == "keyword_address" ) {
                            //         $params += "?"+index+"="+val;
                            //     }
                            //     else if ( index == "layout") {
                            //         $params += "&"+index+"="+val;
                            //     }else if ( index == "rating[]") {
                            //         $params += "&rating="+val;
                            //     }
                            //     else {
                            //         $params += "&"+index+"="+val;
                            //     }
                            // }

                            if( index == "keyword_address" ) {
                                $params += "?"+index+"="+val;
                            }
                            else if ( index == "layout") {
                                $params += "&"+index+"="+val;
                            }else if ( index == "rating[]") {
                                $params += "&rating="+val;
                            }
                            else {
                                $params += "&"+index+"="+val;
                            }

                        });
                        var newurl = window.location.protocol + "//" + window.location.host + window.location.pathname + $params;
                        window.history.pushState({path:newurl},'',newurl);
                    }

                },
            })                        
        };
        plugin.example_function = function () {
        }
        plugin.init();
    }
    $.fn.view_list_hotels = function (options) {
        return this.each(function () {
            if (undefined == $(this).data('view_list_hotels')) {
                let plugin = new $.view_list_hotels(this, options);
                $(this).data('view_list_hotels', plugin);
            }
        });
    }
})(jQuery);
