"use strict";
(function($) {
    $.view_hotel_detail = function(element, options) {
        let defaults = {
            render_list_review: "",
            items_per_page: 6,
            visiblePages: 3,
        }
        let plugin = this;
        plugin.settings = {}
        let $element = $(element);
        plugin.init = function() {
            plugin.settings = $.extend({}, defaults, options);
            let $block_slide = $element.find('.block-slide');
            if($element.hasClass('style-1')){
                $element.find('.gallery-slide').slick({
                    infinite: false,
                    slidesToShow: 3,
                    slidesToScroll: 1,
                    arrows: true,
                    prevArrow: $block_slide.find('.arrow-prev'),
                    nextArrow: $block_slide.find('.arrow-next'),
                    responsive: [{
                            breakpoint: 1199,
                            settings: {
                                slidesToShow: 3,
                                slidesToScroll: 1,
                            }
                        },
                        {
                            breakpoint: 992,
                            settings: {
                                slidesToShow: 2,
                                slidesToScroll: 1,
                            }
                        },
                        {
                            breakpoint: 768,
                            settings: {
                                slidesToShow: 2,
                                slidesToScroll: 1
                            }
                        },
                        {
                            breakpoint: 576,
                            settings: {
                                slidesToShow: 1,
                                slidesToScroll: 1,
                                dots: true,
                                arrows: false

                            }
                        }
                    ]
                });
                $('.block-magnifig').magnificPopup({
                    delegate: 'a',
                    type: 'image',
                    gallery:{enabled:true},
                });   
                // let $img_popup = $element.find('.block-magnifig a');
                // $('.gallery-slide .slick-slide' ).on('click', function(){
                //     let $index = $(this).index();
                //     $($img_popup[$index]).trigger('click');
                // })
                $(function() {
                    var $img_popup = $element.find('.block-magnifig a');
                    var isDragging = false;
                    $('.gallery-slide .slick-slide' )
                        .mousedown(function() { 
                            $(window).mousemove(function() {
                                    isDragging = true;
                                    $(window).unbind("mousemove");
                            });
                        })
                        .mouseup(function() {
                            var wasDragging = isDragging;
                            isDragging = false;
                            $(window).unbind("mousemove");
                            if(!wasDragging){
                                let $index = $(this).index();
                                $($img_popup[$index]).trigger('click');
                            }
                        })
                });
            }else if($element.hasClass('style-3')){
                    var n;
                    function thumbImg(){
                        n =  8;
                        let width_window = window.innerWidth;
                        if(width_window < 1200 && width_window > 768){
                            n = 6;
                        }else if(width_window <= 768 && width_window > 320){
                            n = 5;
                        }else if(width_window <= 320){
                            n = 4;
                        }
                    }
                    thumbImg();
                    $(window).resize(function(){
                        thumbImg();
                    })
                    let srcs = plugin.settings.srcs;
                    let $space_Between = 10;
                    var galleryTop = new Swiper('.gallery-top', {
                        spaceBetween:0,
                        loop: false,
                        navigation: {
                        nextEl: '.swiper-button-next',
                        prevEl: '.swiper-button-prev',
                        },
                        observer: true,
                        observeParents: true,
                        pagination: {
                            el: '.swiper-pagination',
                                clickable: true,
                                renderBullet: function (index, className) {    
                                    let classClick = " ";
                                    if(index == (n-1)) {
                                        classClick = " click-in";
                                    }   
                                    return '<a href="'+ srcs[index]+'" class="' + className + classClick + '"><div style="background-image: url('+srcs[index]+');"></div></a>';                                                        
                                },
                        },
                    });
                    let $swiper_wrapper = $element.find('.gallery-top .swiper-wrapper');
                    let $swiper_wrapper_img = $swiper_wrapper.find('.img-block')
                    let $gallery_top = $element.find('.gallery-top .swiper-slide');
                    let $thumbs = $element.find('.swiper-pagination');
                    let $thumbs_img = $thumbs.find('.swiper-pagination-bullet');
                    let $thumbs_number = $('.swiper-pagination .swiper-pagination-bullet').length;

                    
                    
    
                    function fixSize() {
                        $($thumbs_img).css('margin-right','0px')
                        for (let i = 0; i < (n-1);i++){
                            $($thumbs_img[i]).css('margin-right',''+ $space_Between +'px')
                        }
                        let $rest_thumbs_number = $thumbs_number - n;
                        $($thumbs_img.find('p.rest')).remove();
                        if ($rest_thumbs_number > 0){
                            $($thumbs_img[n-1]).append("<p class='rest'>+"+ $rest_thumbs_number +"</p>");
                        }
                        $($thumbs_img).removeClass('click-in');
                        $($thumbs_img[n-1]).addClass('click-in');
                        let $width_wrapper = $swiper_wrapper.width();
                        let $width_thumb = $thumbs.width();
                        $swiper_wrapper_img.height((2*$width_wrapper)/3);
                        $swiper_wrapper_img.width($width_wrapper);
                        let $size = ($width_thumb-(n-1)*10)/n
                        let $bottom = $size + 75;
                        // Set width,height thumbs 
                        $thumbs_img.width($size);
                        $thumbs_img.height($size);
                        $thumbs.height($size);
        
                        $thumbs.css('bottom',''+ -$size - 10+'px')
    
                        $('.slide-detail').css('padding-bottom',''+ $bottom +'px')
                    }
                    fixSize();
    
                    $(window).resize(function(){
                        fixSize();
                    });
    
                    $('a.click-in').on('click',function(){
                        var $this = $(this);
                        $(".swiper-pagination a").not(this).addClass('click-in');
                        $('.swiper-pagination').magnificPopup({
                            delegate: 'a.click-in',
                            type: 'image',
                            gallery:{enabled:true},
                            callbacks: {
                                close: function(){
                                    $(".swiper-pagination a").not($this).removeClass('click-in');
                                }
                            }
                        });                    
                    })
            }
            $element.find('.wishlist-detail').on('click',function(e){

                let hotel_id = $(this).data('hotel_id');
                let user_id = $(this).data('user_id');
                let $wishlist_icon = $(this);
                if(user_id==""){
                    if ( $('.alert-warning').length == 0){
                        $("body").append('<div class="alert alert-warning" role="alert" style="display: inline-block;position: fixed;right: 60px;top: 30px;z-index:999;" >Please login to use the feature!<button type="button" class="close" data-dismiss="alert" aria-label="Close" style="margin-left: 30px"><span aria-hidden="true">&times;</span></button></div>');
                        setTimeout(function(){
                            $('.alert-warning').remove();
                        },1500)
                    }
                    return;
                }
                let data = {
                    task: "wishlist.change_wishlist",
                    state: 1,
                    hotel_id: hotel_id,
                    user_id: user_id,
                };
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: wpbookinghotel_root_url + wpbookinghotel_api_task,
                    data: data,
                    beforeSend: function () {
                        if(!$wishlist_icon.hasClass("active")){
                            $wishlist_icon.find('i').hide();
                            $wishlist_icon.addClass('loading-item');
                        }
                        else{
                            $wishlist_icon.toggleClass('active');
                        }
                    },
                    error: function (xhr) {
                         
                    },
                    complete: function () {
                         $wishlist_icon.find('i').show();
                            if($wishlist_icon.hasClass('loading-item')){
                                $wishlist_icon.toggleClass('active');
                            }
                            $wishlist_icon.removeClass('loading-item');
                    },
                    success: function (response) {
                        response = JSON.parse(response);
                    }
                });
            })

            $element.find('form[name="form-review"]').each(function(e) {
                $(this).validate({
                    ignore: ""
                });
            });
            $element.find('.share-link .btn-note li a').on('click',function(){
                window.open(this.href,this.title,'width=500,height=500,top=300px,left=300px'); 
                return false;
            })
            $element.find('.btn-save-review').on('click', function() {
                let $form = $(this).closest('form[name="form-review"]');
                let rating = $form.find('input[name="rating"]').val();
                if (rating === '') {
                    $.alert({
                        title: '',
                        content: `<div class="wrapper-alert">
                                        <span class="title-box">Check your information</span>
                                        <span class="content-box">Please rating star</span>
                                   </div>
                                   <i class="icon-nb-hand"></i>`,
                        container: '.block-alert',
                        buttons: {
                            formSubmit: {
                                text: '<i class="icon-nb-close"></i>',
                                btnClass: 'btn-red',
                            }
                        }
                    });
                    return false;
                }
                if (!$form.valid()) {
                    return false;
                }
                $form.submit();
            });

            let nowDate = new Date();
            let today = new Date(nowDate.getFullYear(), nowDate.getMonth(), nowDate.getDate(), 0, 0, 0, 0);
            $element.find('input[id="check-in"]').on('change', function() {
                let date = moment($element.find('input[id="check-in"]').val(), "YYYY-MM-DD").add(1, 'd');
                $element.find('input[id="check-out"]').data('daterangepicker').minDate = date;
                $element.find('input[id="check-out"]').data('daterangepicker').startDate = date;
                $element.find('input[id="check-out"]').val(date.format("YYYY-MM-DD"));
                $element.find('input[name="check_out"]').val(date.format("YYYY-MM-DD"));
            });
            $element.find('input[id="check-out"]').on('change', function() {
                let date = moment($element.find('input[id="check-out"]').val(), "YYYY-MM-DD").subtract(1, 'd');
                $element.find('input[id="check-in"]').data('daterangepicker').maxDate = date;
            });

            $element.find('.btn-select-room-type').on('click', function() {
                let $box_room = $(this).closest('.box-room');
                let room_type_id = $box_room.data('roomtype_id');
                $element.find('select[name="roomtype_id"]').val(room_type_id).trigger('change');
                $('body,html').animate({
                    scrollTop: $element.find('.input-right').offset().top
                }, 500, "linear");
            })

            $element.find('.btn-booking-hotel').on('click', function() {
                let $form = $(this).closest('form[name="booking-form"]');
                let date_checkin = $form.find('input[name="check_in"]').val();
                let date_checkout = $form.find('input[name="check_out"]').val();
                let roomtype_id = $form.find('select[name="roomtype_id"]').val();
                if (date_checkin === '') {
                    $.alert({
                        title: '',
                        content: `<div class="wrapper-alert">
                                        <span class="title-box">Check your information</span>
                                        <span class="content-box">Please select your date checkin</span>
                                   </div>
                                   <i class="icon-nb-hand"></i>`,
                        container: '.block-alert',
                        buttons: {
                            formSubmit: {
                                text: '<i class="icon-nb-close"></i>',
                                btnClass: 'btn-red',
                            }
                        }
                    });
                    return false;
                }
                if (date_checkout === '') {
                    $.alert({
                        title: '',
                        content: `<div class="wrapper-alert">
                                        <span class="title-box">Check your information</span>
                                        <span class="content-box">Please select your date checkout</span>
                                   </div>
                                   <i class="icon-nb-hand"></i>`,
                        container: '.block-alert',
                        buttons: {
                            formSubmit: {
                                text: '<i class="icon-nb-close"></i>',
                                btnClass: 'btn-red',
                            }
                        }
                    });
                    return false;
                }
                if (roomtype_id === '') {
                    $.alert({
                        title: '',
                        content: `<div class="wrapper-alert">
                                        <span class="title-box">Check your information</span>
                                        <span class="content-box">Please select your roomtype</span>
                                   </div>
                                   <i class="icon-nb-hand"></i>`,
                        container: '.block-alert',
                        buttons: {
                            formSubmit: {
                                text: '<i class="icon-nb-close"></i>',
                                btnClass: 'btn-red',
                            }
                        }
                    });
                    return false;
                }
                if (!$form.valid()) {
                    return false;
                }
                $form.submit();
            });

            let $wrapper_list_review = $element.find('.wrapper-list-review');
            let $render_list_review = $(plugin.settings.render_list_review);
            let $render_item_review = $render_list_review.filter('.render-item-review');
            let items_per_page = plugin.settings.items_per_page;
            let total_result = $render_item_review.length;
            let total_page = Math.ceil(total_result / items_per_page);
            let visiblePages = (total_page <= 4) ? (total_page % 4) : 4;

            $element.find('.pagination-review').twbsPagination({
                totalPages: (total_page === 0) ? 1 : total_page,
                visiblePages: visiblePages,
                hideOnlyOnePage: true,
                first: '',
                prev: '<i class="fas fa-arrow-left"></i>',
                next: '<i class="fas fa-arrow-right"></i>',
                last: '',
                onPageClick: function(event, page) {
                    var data_page = $render_item_review.slice((page - 1) * items_per_page, page * items_per_page);
                    $wrapper_list_review.empty();

                    $.each(data_page, function(index, review) {
                        $wrapper_list_review.append(review.outerHTML);
                    });

                }
            });
            
            // var sidebar = new StickySidebar('.hotelier-sticky .content-right', {topSpacing: 20});
            // $('.hotelier-sticky .content-right').stickySidebar({
            //     topSpacing: 60,
            //     bottomSpacing: 60
            // });
            plugin.sticky_sidebar()
            $(window).on('resize', function () {
                plugin.sticky_sidebar()
            });

        };
        plugin.example_function = function() {};
        plugin.sticky_sidebar=function(){
            var $sticky = $element.find('.hotelier-sticky .content-right');
            if ($sticky.length > 0) {
                $($sticky).stick_in_parent()
                    .on('sticky_kit:bottom', function(e) {
                        $($sticky).removeClass('custom-sticky');
                    })
                    .on('sticky_kit:unbottom', function(e) {
                        $($sticky).addClass('custom-sticky');
                    });

                $(window).on('resize', function () {
                    $($sticky).trigger('sticky_kit:detach');
                });
            }
        }
        plugin.init();
    }
    $.fn.view_hotel_detail = function(options) {
        return this.each(function() {
            if (undefined == $(this).data('view_hotel_detail')) {
                let plugin = new $.view_hotel_detail(this, options);
                $(this).data('view_hotel_detail', plugin);
            }
        });
    }
})(jQuery);