
jQuery(document).ready(function ($) {

    "use strict";
    $(window).on('elementor/frontend/init', function() {
        
        elementorFrontend.hooks.addAction( 'frontend/element_ready/section', function( $element ) {
            $(".nb-testimonials-container").each(function(){
        
                var $this           = $(this),
                    currentID       = $this.attr('id'),
                    style           = $this.attr('data-style'),
                    currentSelector = '#' + currentID + ' .nb-testimonials-wrapper';
    
                
                if(style == "multiple_column") {
                    var testimonialParams = {
                        grabCursor: false,
                        slidesPerView: 1,                        
                        spaceBetween: 30,
                        pagination: {
                            el: '#' + currentID + ' .swiper-pagination',
                            clickable: true,
                        },
                        navigation: {
                            nextEl: '#' + currentID + ' .swiper-button-next',
                            prevEl: '#' + currentID + ' .swiper-button-prev',
                        },
                        observer: true,
                        observeParents: true,
                        breakpoints: {
                            // when window width is >= 576px
                            576: {
                                slidesPerView: 1,
                                spaceBetween: 20
                            },
                            // when window width is >= 768px
                            768: {
                                slidesPerView: 2,
                                spaceBetween: 20
                            },
                            // when window width is >= 992px
                            992: {
                                slidesPerView: 2
                            }
                        }
                    }
                    var testimonialSwiper = new Swiper(currentSelector, testimonialParams);                    
                }
                else if(style == "one_column") {
                    var testimonialParams = {
                        grabCursor: false,
                        slidesPerView: 1,
                        slidesPerColumn: 1,
                        pagination: {
                            el: '#' + currentID + ' .swiper-pagination',
                            clickable: true,
                        },
                        observer: true,
                        observeParents: true,
                        navigation: {
                            nextEl: '#' + currentID + ' .swiper-button-next',
                            prevEl: '#' + currentID + ' .swiper-button-prev',
                        },
                    }
                    var testimonialSwiper = new Swiper(currentSelector, testimonialParams);

                    testimonialSwiper.on('slideChange', function () {
                        $('#' + currentID + " .swiper-pagination-bullet").removeClass("swiper-pagination-bullet-active");
                        $('#' + currentID + " .swiper-pagination-bullet:eq("+testimonialSwiper.activeIndex+")").addClass("swiper-pagination-bullet-active");
                    });
                }
                else if(style == "sync_thumbnail_content") {
    
                    var avatarParams = {
                        initialSlide: 1,
                        slidesPerView: 3,
                        centeredSlides: true,
                        slideToClickedSlide: true,
                        observer: true,
                        observeParents: true,
                        // spaceBetween:
                    };
    
                    var contentParams = {
                        grabCursor: false,
                        initialSlide: 1,
                        slidesPerView: 1,
                        centeredSlides: true,
                        observer: true,
                        observeParents: true,
                        pagination: {
                            el: '.testimonial-pagination',
                            clickable: true,
                        },
                        navigation: {
                            nextEl: '.swiper-button-next',
                            prevEl: '.swiper-button-prev',
                        },
                    };
    
    
                    var avatarSelector = '#' + currentID + ' .nb-testimonials-avatar-wrapper';
                    var contentSelector = '#' + currentID + ' .nb-testimonials-content-wrapper';
                    
                    var avatarSwiper = new Swiper(avatarSelector, avatarParams);
                    var contentSwiper = new Swiper(contentSelector, contentParams);
    
                    avatarSwiper.on( 'slideChange', function () {
    
                        var currentIndex = avatarSwiper.activeIndex;
                        contentSwiper.slideTo( currentIndex, 300, false );
    
                    });
    
                    contentSwiper.on('slideChange', function () {
    
                        var currentIndex = contentSwiper.activeIndex;
                        avatarSwiper.slideTo( currentIndex, 300, false );
                        contentSwiper.update();
    
                    });
                }
    
                
            });
        });

    });
});